/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common.inventory;

import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.common.inventory.MBItemInventory;
import com.glodblock.github.modularbees.util.GameUtil;
import com.mojang.serialization.DynamicOps;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.DataComponentUtil;
import org.jetbrains.annotations.NotNull;

public class MBBigItemInventory
extends MBItemInventory {
    private int multiplier = 1;

    public MBBigItemInventory(BlockEntity host, int size) {
        super(host, size);
    }

    public void setMultiplier(int multiplier) {
        this.multiplier = Math.max(multiplier, 1);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.slotLimit * this.multiplier;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.getMaxStackSize() * this.multiplier);
    }

    @NotNull
    public CompoundTag serializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = (CompoundTag)DataComponentUtil.wrapEncodingExceptions((DataComponentHolder)stack, GameUtil.UNLIMITED_ITEM_CODEC, (HolderLookup.Provider)provider);
            itemTag.putInt("Slot", i);
            nbtTagList.add((Object)itemTag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Items", (Tag)nbtTagList);
        nbt.putInt("Size", this.stacks.size());
        return nbt;
    }

    public void deserializeNBT(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        this.setSize(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stacks.size());
        ListTag tagList = nbt.getList("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.getCompound(i);
            int slot = itemTags.getInt("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            GameUtil.UNLIMITED_ITEM_CODEC.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)itemTags).resultOrPartial(err -> ModularBees.LOGGER.error("Tried to load invalid item: '{}'", err)).ifPresent(stack -> this.stacks.set(slot, stack));
        }
        this.onLoad();
    }
}

