/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.common;

import com.glodblock.github.glodium.registry.RegistryHandler;
import com.glodblock.github.glodium.util.GlodUtil;
import com.glodblock.github.modularbees.ModularBees;
import com.glodblock.github.modularbees.common.MBSingletons;
import com.glodblock.github.modularbees.common.blocks.base.BlockMBTileBase;
import com.glodblock.github.modularbees.common.caps.EnergyHandlerHost;
import com.glodblock.github.modularbees.common.caps.FluidHandlerHost;
import com.glodblock.github.modularbees.common.caps.ItemHandlerHost;
import com.glodblock.github.modularbees.common.fluids.FluidDragonBreath;
import com.glodblock.github.modularbees.common.recipe.ElectrodeRecipe;
import com.glodblock.github.modularbees.common.recipe.TreaterRecipe;
import com.glodblock.github.modularbees.common.tileentities.base.TileMBBase;
import com.glodblock.github.modularbees.container.ContainerMBAlveary;
import com.glodblock.github.modularbees.container.ContainerMBBeeExtractor;
import com.glodblock.github.modularbees.container.ContainerMBDragon;
import com.glodblock.github.modularbees.container.ContainerMBFeeder;
import com.glodblock.github.modularbees.container.ContainerMBGearbox;
import com.glodblock.github.modularbees.container.ContainerMBHeater;
import com.glodblock.github.modularbees.container.ContainerMBImport;
import com.glodblock.github.modularbees.container.ContainerMBModularBeehive;
import com.glodblock.github.modularbees.container.ContainerMBModularCentrifuge;
import com.glodblock.github.modularbees.container.ContainerMBOverclocker;
import com.glodblock.github.modularbees.container.ContainerMBTreater;
import com.glodblock.github.modularbees.container.base.MBGuiHandler;
import com.glodblock.github.modularbees.util.RegisterTask;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class MBRegistryHandler
extends RegistryHandler {
    public static final MBRegistryHandler INSTANCE = new MBRegistryHandler();

    public MBRegistryHandler() {
        super("modularbees");
        this.cap(ItemHandlerHost.class, Capabilities.ItemHandler.BLOCK, ItemHandlerHost::getItemInventory);
        this.cap(FluidHandlerHost.class, Capabilities.FluidHandler.BLOCK, FluidHandlerHost::getFluidInventory);
        this.cap(EnergyHandlerHost.class, Capabilities.EnergyStorage.BLOCK, EnergyHandlerHost::getEnergyStorage);
    }

    public <T extends TileMBBase> void block(String name, BlockMBTileBase<T> block, Class<T> clazz, BlockEntityType.BlockEntitySupplier<? extends T> supplier) {
        block.bindTileEntity(clazz, GlodUtil.getTileType(clazz, supplier, block));
        this.block(name, block, b -> block.createItem());
        this.tile(name, block.getBlockEntityType());
    }

    public void init() {
    }

    protected void onRegisterBlocks() {
        super.onRegisterBlocks();
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)ModularBees.id("dragon_breath"), (Object)((Object)MBSingletons.DRAGON_BREATH));
        this.blocks.forEach(e -> {
            Object patt0$temp = e.getRight();
            if (patt0$temp instanceof RegisterTask) {
                RegisterTask task = (RegisterTask)patt0$temp;
                task.onRegister(ModularBees.id((String)e.getLeft()));
            }
        });
    }

    protected void onRegisterItems() {
        super.onRegisterItems();
        this.items.forEach(e -> {
            Object patt0$temp = e.getRight();
            if (patt0$temp instanceof RegisterTask) {
                RegisterTask task = (RegisterTask)patt0$temp;
                task.onRegister(ModularBees.id((String)e.getLeft()));
            }
        });
    }

    private void registerContainer() {
        MBGuiHandler.registerResolver(MBGuiHandler.TileResolver::new);
        ContainerMBModularBeehive.TYPE.register();
        ContainerMBAlveary.TYPE.register();
        ContainerMBFeeder.TYPE.register();
        ContainerMBOverclocker.TYPE.register();
        ContainerMBTreater.TYPE.register();
        ContainerMBDragon.TYPE.register();
        ContainerMBModularCentrifuge.TYPE.register();
        ContainerMBImport.TYPE.register();
        ContainerMBHeater.TYPE.register();
        ContainerMBGearbox.TYPE.register();
        ContainerMBBeeExtractor.TYPE.register();
    }

    private void registerRecipe() {
        Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)TreaterRecipe.ID, TreaterRecipe.TYPE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)TreaterRecipe.ID, TreaterRecipe.SERIALIZER);
        Registry.register((Registry)BuiltInRegistries.RECIPE_TYPE, (ResourceLocation)ElectrodeRecipe.ID, ElectrodeRecipe.TYPE);
        Registry.register((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (ResourceLocation)ElectrodeRecipe.ID, ElectrodeRecipe.SERIALIZER);
    }

    private void registerFluid() {
        Registry.register((Registry)NeoForgeRegistries.FLUID_TYPES, (ResourceLocation)ModularBees.id("dragon_breath"), (Object)FluidDragonBreath.TYPE);
        Registry.register((Registry)BuiltInRegistries.FLUID, (ResourceLocation)ModularBees.id("dragon_breath"), (Object)FluidDragonBreath.getFluid());
        Registry.register((Registry)BuiltInRegistries.FLUID, (ResourceLocation)ModularBees.id("dragon_breath_flow"), (Object)FluidDragonBreath.getFlowFluid());
    }

    public void runRegister() {
        super.runRegister();
        this.registerFluid();
        this.registerContainer();
        this.registerRecipe();
    }

    @SubscribeEvent
    public void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        super.onRegisterCapabilities(event);
    }

    public Collection<ItemLike> getItems() {
        return Stream.concat(this.items.stream(), this.blocks.stream()).map(Pair::getRight).collect(Collectors.toList());
    }

    public Collection<Block> getBlocks() {
        return this.blocks.stream().map(Pair::getRight).collect(Collectors.toList());
    }

    public void registerTab(Registry<CreativeModeTab> registry) {
        CreativeModeTab tab = CreativeModeTab.builder().icon(() -> new ItemStack((ItemLike)MBSingletons.MODULAR_BEEHIVE_CORE)).title((Component)Component.translatable((String)"itemGroup.mb")).displayItems((p, o) -> {
            for (Pair entry : this.items) {
                o.accept((ItemLike)entry.getRight());
            }
            for (Pair entry : this.blocks) {
                o.accept((ItemLike)entry.getRight());
            }
        }).build();
        Registry.register(registry, (ResourceLocation)ModularBees.id("tab_main"), (Object)tab);
    }
}

