/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.modularbees.client.gui.elements;

import com.glodblock.github.modularbees.client.util.RelativeRect2i;
import com.glodblock.github.modularbees.client.util.TooltipElement;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BeeDisplay
extends RelativeRect2i
implements Renderable,
TooltipElement {
    protected final Supplier<BeehiveBlockEntity.BeeData> supplier;

    public BeeDisplay(Supplier<BeehiveBlockEntity.BeeData> supplier) {
        this.supplier = supplier;
    }

    @Nullable
    private BeeInfo getInfo() {
        BeehiveBlockEntity.BeeData data = this.supplier.get();
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.toOccupant().entityData().copyTag();
        String type = tag.getString("type");
        if (type.isEmpty() || type.equals("minecraft:")) {
            type = tag.getString("id");
        }
        BeeIngredient bee = (BeeIngredient)BeeIngredientFactory.getIngredient((String)type).get();
        return new BeeInfo(bee, tag);
    }

    @Override
    public List<Component> getTooltipMessage(boolean isShift) {
        BeeInfo info = this.getInfo();
        if (info != null) {
            Entity bee = info.bee.getCachedEntity((Level)Minecraft.getInstance().level);
            ArrayList<Component> tooltip = new ArrayList<Component>();
            if (bee != null && bee.getEncodeId() != null) {
                if (bee instanceof ConfigurableBee && info.tag.contains("type")) {
                    ((ConfigurableBee)bee).setBeeType(info.tag.getString("type"));
                }
                tooltip.add(bee.getName());
                if (isShift) {
                    BeeHelper.populateBeeInfoFromTag((CompoundTag)info.tag, tooltip);
                } else {
                    tooltip.add((Component)Component.translatable((String)"productivebees.information.hold_shift"));
                }
                return tooltip;
            }
        }
        return List.of();
    }

    @Override
    public boolean shouldDisplay(int mouseX, int mouseY) {
        return this.contains(mouseX, mouseY);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        BeeInfo info = this.getInfo();
        if (info != null) {
            BeeRenderer.render((GuiGraphics)graphics, (int)this.getX(), (int)this.getY(), (BeeIngredient)info.bee, (Minecraft)Minecraft.getInstance());
        }
    }

    record BeeInfo(BeeIngredient bee, CompoundTag tag) {
    }
}

