/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.shadowsoffire.apotheosis.client.ApothRenderTypes;
import dev.shadowsoffire.apotheosis.loot.RarityRenderData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

public class ShadowRenderer {
    static void renderShadow(PoseStack poseStack, MultiBufferSource buffer, Entity entity, float partialTicks, LevelReader level, RarityRenderData.ShadowData data, int color) {
        float size = data.size();
        if (size <= 0.0f) {
            return;
        }
        double x = Mth.lerp((double)partialTicks, (double)entity.xOld, (double)entity.getX());
        double y = Mth.lerp((double)partialTicks, (double)entity.yOld, (double)entity.getY());
        double z = Mth.lerp((double)partialTicks, (double)entity.zOld, (double)entity.getZ());
        int xMin = Mth.floor((double)(x - (double)size));
        int xMax = Mth.floor((double)(x + (double)size));
        int yMin = Mth.floor((double)(y - 2.0));
        int yMax = Mth.floor((double)y);
        int zMin = Mth.floor((double)(z - (double)size));
        int zMax = Mth.floor((double)(z + (double)size));
        PoseStack.Pose pose = poseStack.last();
        VertexConsumer vtx = buffer.getBuffer(ApothRenderTypes.affixShadow(data.texture()));
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int zi = zMin; zi <= zMax; ++zi) {
            for (int xi = xMin; xi <= xMax; ++xi) {
                pos.set(xi, 0, zi);
                ChunkAccess chunkaccess = level.getChunk((BlockPos)pos);
                for (int yi = yMin; yi <= yMax; ++yi) {
                    pos.setY(yi);
                    ShadowRenderer.renderBlockShadow(pose, vtx, entity, chunkaccess, partialTicks, level, (BlockPos)pos, x, y, z, data, color);
                }
            }
        }
    }

    private static void renderBlockShadow(PoseStack.Pose pose, VertexConsumer vertexConsumer, Entity entity, ChunkAccess chunk, float partialTicks, LevelReader level, BlockPos pos, double x, double y, double z, RarityRenderData.ShadowData data, int color) {
        VoxelShape voxelshape;
        BlockPos blockpos = pos;
        BlockState blockstate = chunk.getBlockState(blockpos);
        if (blockstate.getRenderShape() != RenderShape.INVISIBLE && !(voxelshape = blockstate.getShape((BlockGetter)chunk, blockpos)).isEmpty() && Block.isFaceFull((VoxelShape)voxelshape, (Direction)Direction.DOWN)) {
            int frames = data.frames();
            float frameTime = data.frameTime();
            float frame = (int)(((float)Minecraft.getInstance().level.getGameTime() + partialTicks) / frameTime % (float)frames);
            float size = data.size();
            AABB aabb = voxelshape.bounds();
            aabb = aabb.intersect(new AABB(entity.getX() - (double)pos.getX() - (double)size, 0.0, entity.getZ() - (double)pos.getZ() - (double)size, entity.getX() - (double)pos.getX() + (double)size, aabb.maxY, entity.getZ() - (double)pos.getZ() + (double)size));
            double minX = (double)pos.getX() + aabb.minX;
            double maxX = (double)pos.getX() + aabb.maxX;
            double minY = (double)pos.getY() + aabb.maxY;
            double minZ = (double)pos.getZ() + aabb.minZ;
            double maxZ = (double)pos.getZ() + aabb.maxZ;
            float xi = (float)(minX - x);
            float xp = (float)(maxX - x);
            float yi = (float)(minY - y) + 0.001f;
            float zi = (float)(minZ - z);
            float zp = (float)(maxZ - z);
            float u1 = -xi / 2.0f / size + 0.5f;
            float u2 = -xp / 2.0f / size + 0.5f;
            float v1 = -zi / 2.0f / size + 0.5f;
            float v2 = -zp / 2.0f / size + 0.5f;
            ShadowRenderer.shadowVertex(pose, vertexConsumer, color, xi, yi, zi, u1, v1 / (float)frames + frame / (float)frames);
            ShadowRenderer.shadowVertex(pose, vertexConsumer, color, xi, yi, zp, u1, v2 / (float)frames + frame / (float)frames);
            ShadowRenderer.shadowVertex(pose, vertexConsumer, color, xp, yi, zp, u2, v2 / (float)frames + frame / (float)frames);
            ShadowRenderer.shadowVertex(pose, vertexConsumer, color, xp, yi, zi, u2, v1 / (float)frames + frame / (float)frames);
        }
    }

    private static void shadowVertex(PoseStack.Pose pose, VertexConsumer consumer, int color, float offsetX, float offsetY, float offsetZ, float u, float v) {
        Vector3f vector3f = pose.pose().transformPosition(offsetX, offsetY, offsetZ, new Vector3f());
        consumer.addVertex(vector3f.x(), vector3f.y(), vector3f.z(), color, u, v, OverlayTexture.NO_OVERLAY, 0xF000F0, 0.0f, 1.0f, 0.0f);
    }
}

