/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.affix.reforging;

import dev.shadowsoffire.apotheosis.Apoth;
import dev.shadowsoffire.apotheosis.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apotheosis.loot.RarityRegistry;
import dev.shadowsoffire.placebo.block_entity.TickingBlockEntity;
import dev.shadowsoffire.placebo.cap.InternalItemHandler;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class ReforgingTableTile
extends BlockEntity
implements TickingBlockEntity {
    public int time = 0;
    public boolean step1 = true;
    protected InternalItemHandler inv = new InternalItemHandler(2){

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return ReforgingTableTile.this.isValidRarityMat(stack);
            }
            return stack.is(Apoth.Items.SIGIL_OF_REBIRTH);
        }

        protected void onContentsChanged(int slot) {
            ReforgingTableTile.this.setChanged();
        }
    };

    public ReforgingTableTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super(Apoth.Tiles.REFORGING_TABLE, pWorldPosition, pBlockState);
    }

    public boolean isValidRarityMat(ItemStack stack) {
        DynamicHolder<LootRarity> rarity = RarityRegistry.getMaterialRarity(stack.getItem());
        return rarity.isBound() && this.getRecipeFor((LootRarity)rarity.get()) != null;
    }

    @Nullable
    public ReforgingRecipe getRecipeFor(LootRarity rarity) {
        return this.level.getRecipeManager().getAllRecipesFor(Apoth.RecipeTypes.REFORGING).stream().map(RecipeHolder::value).filter(r -> r.rarity().get() == rarity && r.tables().contains((Holder)this.getBlockState().getBlock().builtInRegistryHolder())).findFirst().orElse(null);
    }

    public void clientTick(Level pLevel, BlockPos pPos, BlockState pState) {
        Player player = pLevel.getNearestPlayer((double)pPos.getX() + 0.5, (double)pPos.getY() + 0.5, (double)pPos.getZ() + 0.5, 4.0, false);
        if (player != null) {
            ++this.time;
        } else {
            if (this.time == 0 && this.step1) {
                return;
            }
            ++this.time;
        }
        if (this.step1 && this.time == 59) {
            this.step1 = false;
            this.time = 0;
        } else if (this.time == 4 && !this.step1) {
            RandomSource rand = pLevel.random;
            for (int i = 0; i < 6; ++i) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.CRIT, (double)pPos.getX() + 0.5 - 0.1 * rand.nextDouble(), (double)pPos.getY() + 0.8125, (double)pPos.getZ() + 0.5 + 0.1 * rand.nextDouble(), 0.0, 0.0, 0.0);
            }
            pLevel.playLocalSound((double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), SoundEvents.ANVIL_PLACE, SoundSource.BLOCKS, 0.03f, 1.7f + rand.nextFloat() * 0.2f, true);
            this.step1 = true;
            this.time = 0;
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.saveAdditional(tag, regs);
        tag.put("inventory", (Tag)this.inv.serializeNBT(regs));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider regs) {
        super.loadAdditional(tag, regs);
        this.inv.deserializeNBT(regs, tag.getCompound("inventory"));
    }

    public IItemHandler getInventory() {
        return this.inv;
    }
}

