/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.advancements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.socket.gem.Purity;
import dev.shadowsoffire.apotheosis.socket.gem.UnsocketedGem;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class GemCutTrigger
extends SimpleCriterionTrigger<Instance> {
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, ItemStack stack) {
        UnsocketedGem gem = UnsocketedGem.of(stack);
        if (gem.isValid()) {
            this.trigger(player, inst -> inst.test(gem));
        }
    }

    public record Instance(Optional<ContextAwarePredicate> player, ItemPredicate gem, Optional<Purity> purity) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<Instance> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(Instance::player), (App)ItemPredicate.CODEC.fieldOf("item").forGetter(Instance::gem), (App)Purity.CODEC.optionalFieldOf("purity").forGetter(Instance::purity)).apply((Applicative)inst, Instance::new));

        public boolean test(UnsocketedGem inst) {
            return this.gem.test(inst.gemStack()) && (this.purity.isEmpty() || this.purity.get() == inst.purity());
        }
    }
}

