/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BambooPlantRecollectable
extends PlantRecollectable {
    public BambooPlantRecollectable() {
        super("bamboo");
    }

    @Override
    public boolean canBeHarvested(Level world, BlockPos pos, BlockState blockState) {
        return world.getBlockState(pos).getBlock().equals(Blocks.BAMBOO) && world.getBlockState(pos.above()).getBlock().equals(Blocks.BAMBOO);
    }

    @Override
    public List<ItemStack> doHarvestOperation(Level world, BlockPos pos, BlockState blockState) {
        int margin = 1;
        int orginalPos = pos.getY();
        while (world.getBlockState(pos.above()).getBlock().equals(Blocks.BAMBOO)) {
            pos = pos.above();
        }
        NonNullList stacks = NonNullList.create();
        while (pos.getY() > margin + orginalPos) {
            stacks.addAll(BlockUtils.getBlockDrops(world, pos));
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            pos = pos.below();
        }
        return stacks;
    }

    @Override
    public boolean shouldCheckNextPlant(Level world, BlockPos pos, BlockState blockState) {
        return world.getBlockState(pos).getBlock().equals(Blocks.BAMBOO) && world.getBlockState(pos.above(1)).getBlock().equals(Blocks.BAMBOO) && !world.getBlockState(pos.above(2)).getBlock().equals(Blocks.BAMBOO);
    }

    @Override
    public ItemStack getSeedDrop(Level world, BlockPos pos, BlockState blockState) {
        return new ItemStack((ItemLike)Blocks.BAMBOO);
    }
}

