/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.tileentity;

import com.blakebr0.cucumber.crafting.ShapelessCraftingInput;
import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.ContainerDataBuilder;
import com.blakebr0.mysticalagriculture.api.crafting.IEnchanterRecipe;
import com.blakebr0.mysticalagriculture.api.machine.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeTier;
import com.blakebr0.mysticalautomation.block.EnchanternatorBlock;
import com.blakebr0.mysticalautomation.compat.MysticalCompat;
import com.blakebr0.mysticalautomation.container.EnchanternatorContainer;
import com.blakebr0.mysticalautomation.init.ModTileEntities;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class EnchanternatorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int[] INPUT_SLOTS = IntStream.rangeClosed(0, 2).toArray();
    private static final int FUEL_SLOT = 3;
    private static final int OUTPUT_SLOT = 4;
    public static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 200;
    public static final int FUEL_USAGE = 20;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory;
    private final BaseItemStackHandler recipeInventory = EnchanternatorTileEntity.createRecipeInventoryHandler(slot -> {
        this.isGridChanged = true;
        this.setChangedFast();
    });
    private final MachineUpgradeItemStackHandler upgradeInventory;
    private final DynamicEnergyStorage energy;
    private final SidedInventoryWrapper[] sidedInventoryWrappers;
    private final CachedRecipe<CraftingInput, IEnchanterRecipe> recipe;
    private final ContainerData dataAccess;
    private MachineUpgradeTier tier;
    private int progress;
    private int selectedLevel;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;
    private boolean isGridChanged = true;

    public EnchanternatorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.ENCHANTERNATOR.get(), pos, state);
        this.inventory = EnchanternatorTileEntity.createInventoryHandler(this.recipeInventory, slot -> this.setChanged());
        this.upgradeInventory = new MachineUpgradeItemStackHandler();
        this.energy = new DynamicEnergyStorage(80000, () -> ((EnchanternatorTileEntity)this).setChangedFast());
        this.sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
        this.recipe = new CachedRecipe((RecipeType)MysticalCompat.RecipeTypes.ENCHANTER.get());
        this.dataAccess = ContainerDataBuilder.builder().sync(() -> ((DynamicEnergyStorage)this.energy).getEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setEnergyStored(arg_0)).sync(() -> ((DynamicEnergyStorage)this.energy).getMaxEnergyStored(), arg_0 -> ((DynamicEnergyStorage)this.energy).setMaxEnergyStorage(arg_0)).sync(() -> this.fuelLeft, value -> {
            this.fuelLeft = value;
        }).sync(() -> this.fuelItemValue, value -> {
            this.fuelItemValue = value;
        }).sync(() -> this.progress, value -> {
            this.progress = value;
        }).sync(this::getOperationTime, value -> {}).sync(() -> this.selectedLevel, value -> {
            this.selectedLevel = value;
        }).build();
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.mysticalautomation.enchanternator");
    }

    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new EnchanternatorContainer(i, inventory, this.inventory, this.recipeInventory, this.upgradeInventory, this.dataAccess, this.getBlockPos());
    }

    public MachineUpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.selectedLevel = tag.getInt("SelectedLevel");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.recipeInventory.deserializeNBT(lookup, tag.getCompound("RecipeInventory"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("SelectedLevel", this.selectedLevel);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.put("RecipeInventory", (Tag)this.recipeInventory.serializeNBT(lookup));
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnchanternatorTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(3);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(3, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage(tier.getFuelCapacity(80000));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        tile.isRunning = false;
        if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            IEnchanterRecipe recipe = tile.getActiveRecipe();
            if (recipe != null && tile.selectedLevel > 0) {
                InputResult inputs = tile.getInputResult(recipe);
                int maxLevel = recipe.getMaxResultEnchantmentLevel((RecipeInput)tile.toCraftingInput());
                if (inputs.hasAll && maxLevel >= tile.selectedLevel) {
                    ItemStack output;
                    ItemStack result = recipe.assemble(tile.toCraftingInput(), (HolderLookup.Provider)level.registryAccess(), maxLevel);
                    if (StackHelper.canCombineStacks((ItemStack)result, (ItemStack)(output = tile.inventory.getStackInSlot(4)))) {
                        tile.isRunning = true;
                        ++tile.progress;
                        tile.energy.extractEnergy(tile.getFuelUsage(), false);
                        if (tile.progress >= tile.getOperationTime()) {
                            int[] amounts = inputs.amounts;
                            for (int i = 0; i < amounts.length; ++i) {
                                int amount = amounts[i];
                                ItemStack input = tile.inventory.getStackInSlot(INPUT_SLOTS[i]);
                                tile.inventory.setStackInSlot(INPUT_SLOTS[i], StackHelper.shrinkAndRetainContainer((ItemStack)input, (int)amount));
                            }
                            tile.inventory.setStackInSlot(4, StackHelper.combineStacks((ItemStack)output, (ItemStack)result));
                            tile.progress = 0;
                        }
                        tile.setChangedFast();
                    }
                } else if (tile.progress > 0) {
                    tile.progress = 0;
                    tile.setChangedFast();
                }
            } else if (tile.progress > 0) {
                tile.progress = 0;
                tile.setChangedFast();
            }
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)EnchanternatorBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return EnchanternatorTileEntity.createInventoryHandler(EnchanternatorTileEntity.createRecipeInventoryHandler(), null);
    }

    public static BaseItemStackHandler createInventoryHandler(BaseItemStackHandler recipeInventory, @Nullable OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)5, (OnContentsChangedFunction)onContentsChanged, handler -> {
            for (int slot2 : INPUT_SLOTS) {
                handler.addSlotLimit(slot2, 512);
            }
            handler.setCanInsert((slot, stack) -> {
                if (ArrayUtils.contains((int[])INPUT_SLOTS, (int)slot)) {
                    ItemStack recipeStack = recipeInventory.getStackInSlot(slot);
                    return !recipeStack.isEmpty() && StackHelper.areStacksEqual((ItemStack)recipeStack, (ItemStack)stack);
                }
                return true;
            });
            handler.setOutputSlots(new int[]{4});
            handler.setCanExtract(slot -> slot == 4 || slot == 3 && !FurnaceBlockEntity.isFuel((ItemStack)handler.getStackInSlot(slot)));
        });
    }

    public static BaseItemStackHandler createRecipeInventoryHandler() {
        return EnchanternatorTileEntity.createRecipeInventoryHandler(null);
    }

    public static BaseItemStackHandler createRecipeInventoryHandler(@Nullable OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)3, (OnContentsChangedFunction)onContentsChanged, handler -> {});
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getSelectedLevel() {
        return this.selectedLevel;
    }

    public IItemHandler getSidedInventory(@Nullable Direction direction) {
        Direction direction2 = direction;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"UP", "DOWN"}, (Direction)direction2, n)) {
            case 0 -> this.sidedInventoryWrappers[0];
            case 1 -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    public void setSelectedLevel(int level) {
        this.selectedLevel = Math.clamp((long)level, 0, 5);
        this.setChangedFast();
    }

    @Nullable
    public IEnchanterRecipe getActiveRecipe() {
        if (this.isGridChanged) {
            this.isGridChanged = false;
            List<ItemStack> items = List.of(this.recipeInventory.getStackInSlot(0).copyWithCount(512), this.recipeInventory.getStackInSlot(1).copyWithCount(512), this.recipeInventory.getStackInSlot(2));
            ShapelessCraftingInput input = new ShapelessCraftingInput(items);
            return (IEnchanterRecipe)this.recipe.checkAndGet((RecipeInput)input, this.level);
        }
        return (IEnchanterRecipe)this.recipe.get();
    }

    private int getOperationTime() {
        return this.tier == null ? 200 : this.tier.getOperationTime(200);
    }

    private int getFuelUsage() {
        return this.tier == null ? 20 : this.tier.getFuelUsage(20);
    }

    private CraftingInput toCraftingInput() {
        return this.inventory.toShapelessCraftingInput(0, 3);
    }

    private InputResult getInputResult(IEnchanterRecipe recipe) {
        int[] amounts = new int[INPUT_SLOTS.length];
        int[] remaining = new int[INPUT_SLOTS.length];
        for (int i = 0; i < INPUT_SLOTS.length; ++i) {
            remaining[i] = this.inventory.getStackInSlot(INPUT_SLOTS[i]).getCount();
        }
        NonNullList ingredients = recipe.getIngredients();
        int required = 0;
        block1: for (int i = 0; i < ingredients.size(); ++i) {
            Ingredient ingredient = (Ingredient)ingredients.get(i);
            if (ingredient.isEmpty()) continue;
            int amount = recipe.getCount(i);
            required += amount;
            for (int j = 0; j < INPUT_SLOTS.length; ++j) {
                int slot = INPUT_SLOTS[j];
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (remaining[j] < amount || !ingredient.test(stack)) continue;
                int n = j;
                remaining[n] = remaining[n] - amount;
                int n2 = j;
                amounts[n2] = amounts[n2] + amount;
                continue block1;
            }
        }
        return new InputResult(Arrays.stream(amounts).sum() == required, amounts);
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, @Nullable Direction direction) {
        if (direction == null) {
            return true;
        }
        if (ArrayUtils.contains((int[])INPUT_SLOTS, (int)slot) && direction == Direction.UP) {
            return true;
        }
        if (slot == 3 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        return false;
    }

    private record InputResult(boolean hasAll, int[] amounts) {
    }
}

