/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.slot.BaseItemStackHandlerSlot;
import com.blakebr0.cucumber.util.QuickMover;
import com.blakebr0.mysticalagriculture.api.machine.IMachineUpgrade;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalautomation.init.ModMenuTypes;
import com.blakebr0.mysticalautomation.lib.ModTags;
import com.blakebr0.mysticalautomation.tileentity.FertilizerTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class FertilizerContainer
extends BaseContainerMenu {
    private final ContainerData data;
    private final QuickMover mover;

    public FertilizerContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, FertilizerTileEntity.createInventoryHandler(), new MachineUpgradeItemStackHandler(), (ContainerData)new SimpleContainerData(4), buffer.readBlockPos());
    }

    public FertilizerContainer(int id, Inventory playerInventory, BaseItemStackHandler inventory, MachineUpgradeItemStackHandler upgradeInventory, ContainerData data, BlockPos pos) {
        super((MenuType)ModMenuTypes.FERTILIZER.get(), id, pos);
        int j;
        int i;
        this.data = data;
        this.mover = new QuickMover((x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)upgradeInventory, 0, 152, 9));
        for (i = 0; i < 2; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot((Slot)new BaseItemStackHandlerSlot(inventory, j + i * 4, 75 + j * 18, 39 + i * 18));
            }
        }
        this.addSlot((Slot)new BaseItemStackHandlerSlot(inventory, 8, 30, 56));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 112 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 170));
        }
        this.mover.after(10).add((slot, stack, player) -> stack.getItem() instanceof IMachineUpgrade, 0, 1).add((slot, stack, player) -> stack.is(ModTags.Items.FERTILIZERS), 1, 8).add((slot, stack, player) -> stack.getBurnTime(null) > 0, 9, 1).add((slot, stack, player) -> slot < this.slots.size() - 9, this.slots.size() - 9, 9).add((slot, stack, player) -> slot >= this.slots.size() - 9, this.slots.size() - 36, 27);
        this.mover.fallback(10, 36);
        this.addDataSlots(data);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (!this.mover.run(index, itemstack1, player)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public int getEnergyStored() {
        return this.data.get(0);
    }

    public int getMaxEnergyStored() {
        return this.data.get(1);
    }

    public int getFuelLeft() {
        return this.data.get(2);
    }

    public int getFuelItemValue() {
        return this.data.get(3);
    }
}

