/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalautomation.container;

import com.blakebr0.cucumber.container.BaseContainerMenu;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.slot.BaseItemStackHandlerSlot;
import com.blakebr0.cucumber.util.QuickMover;
import com.blakebr0.mysticalagriculture.api.crafting.IAwakeningRecipe;
import com.blakebr0.mysticalagriculture.api.machine.IMachineUpgrade;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalautomation.compat.MysticalCompat;
import com.blakebr0.mysticalautomation.container.slot.FakeSlot;
import com.blakebr0.mysticalautomation.container.slot.HiddenSlot;
import com.blakebr0.mysticalautomation.init.ModMenuTypes;
import com.blakebr0.mysticalautomation.tileentity.AwakeningAltarnatorTileEntity;
import com.blakebr0.mysticalautomation.util.IFakeRecipeContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class AwakeningAltarnatorContainer
extends BaseContainerMenu
implements IFakeRecipeContainer {
    private final ContainerData data;
    private final BaseItemStackHandler matrix;
    private final QuickMover mover;
    private final Slot result;
    private final Level level;

    public AwakeningAltarnatorContainer(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, AwakeningAltarnatorTileEntity.createInventoryHandler(), AwakeningAltarnatorTileEntity.createRecipeInventoryHandler(), new MachineUpgradeItemStackHandler(), (ContainerData)new SimpleContainerData(6), buffer.readBlockPos());
    }

    public AwakeningAltarnatorContainer(int id, Inventory playerInventory, BaseItemStackHandler inventory, BaseItemStackHandler recipeInventory, MachineUpgradeItemStackHandler upgradeInventory, ContainerData data, BlockPos pos) {
        super((MenuType)ModMenuTypes.AWAKENING_ALTARNATOR.get(), id, pos);
        int i;
        this.data = data;
        this.matrix = recipeInventory;
        this.mover = new QuickMover((x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3));
        this.level = playerInventory.player.level();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)upgradeInventory, 0, 172, 9));
        for (i = 0; i < 9; ++i) {
            this.addSlot((Slot)new BaseItemStackHandlerSlot(inventory, i, 18 + i * 18, 101));
        }
        this.addSlot((Slot)new BaseItemStackHandlerSlot(inventory, 9, 30, 56));
        this.addSlot((Slot)new BaseItemStackHandlerSlot(inventory, 10, 168, 49));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 0, 84, 48));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 1, 59, 23));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 2, 84, 20));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 3, 109, 23));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 4, 111, 48));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 5, 109, 73));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 6, 84, 76));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 7, 59, 73));
        this.addSlot((Slot)new FakeSlot(recipeInventory, 8, 56, 48));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 18 + j * 18, 135 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 18 + i * 18, 193));
        }
        this.result = this.addSlot(new HiddenSlot((Container)new ResultContainer(), 0, 0));
        this.mover.after(21).add((slot, stack, player) -> stack.getItem() instanceof IMachineUpgrade, 0, 1).add((slot, stack, player) -> this.isRecipeInput(stack), 1, 9).add((slot, stack, player) -> stack.getBurnTime(null) > 0, 10, 1).add((slot, stack, player) -> slot < this.slots.size() - 10, this.slots.size() - 10, 9).add((slot, stack, player) -> slot >= this.slots.size() - 10, this.slots.size() - 37, 27);
        this.mover.fallback(21, 36);
        this.addDataSlots(data);
        if (!this.level.isClientSide()) {
            this.onRecipeChanged();
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (!this.mover.run(index, itemstack1, player)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = slotId < 0 ? null : (Slot)this.slots.get(slotId);
        if (slot instanceof FakeSlot) {
            if (button == 2) {
                slot.set(ItemStack.EMPTY);
            } else {
                ItemStack carried = this.getCarried();
                slot.set(carried.isEmpty() ? ItemStack.EMPTY : carried.copy());
            }
            this.onRecipeChanged();
            return;
        }
        super.clicked(slotId, button, clickType, player);
    }

    @Override
    public void setFakeRecipeSlot(Slot slot, ItemStack stack) {
        slot.set(stack);
        this.onRecipeChanged();
    }

    public ItemStack getResult() {
        return this.result.getItem();
    }

    public int getEnergyStored() {
        return this.data.get(0);
    }

    public int getMaxEnergyStored() {
        return this.data.get(1);
    }

    public int getFuelLeft() {
        return this.data.get(2);
    }

    public int getFuelItemValue() {
        return this.data.get(3);
    }

    public int getProgress() {
        return this.data.get(4);
    }

    public int getOperationTime() {
        return this.data.get(5);
    }

    private void onRecipeChanged() {
        CraftingInput input = this.matrix.toCraftingInput(3, 3);
        IAwakeningRecipe recipe = this.level.getRecipeManager().getRecipeFor((RecipeType)MysticalCompat.RecipeTypes.AWAKENING.get(), (RecipeInput)input, this.level).map(RecipeHolder::value).orElse(null);
        ItemStack item = recipe == null ? ItemStack.EMPTY : recipe.assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
        this.result.set(item);
    }

    private boolean isRecipeInput(ItemStack stack) {
        for (int i = 0; i < this.matrix.getSlots(); ++i) {
            ItemStack matrixStack = this.matrix.getStackInSlot(i);
            if (!StackHelper.areItemsEqual((ItemStack)stack, (ItemStack)matrixStack)) continue;
            return true;
        }
        return false;
    }
}

