/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.item;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.entity.Luggage;
import com.gizmo.luggage.item.AbstractLuggageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class LuggageItem
extends AbstractLuggageItem<Luggage> {
    public LuggageItem(Item.Properties properties) {
        super(LuggageRegistries.LUGGAGE, properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean insertedAny = false;
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult result = LuggageItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.getType() == HitResult.Type.BLOCK) {
            Vec3 blockPos = result.getLocation();
            BlockPos pos = result.getBlockPos();
            if (!level.isClientSide() && player.isSecondaryUseActive() && level.getBlockState(BlockPos.containing((Position)blockPos)).hasBlockEntity()) {
                BlockEntity be = level.getBlockEntity(result.getBlockPos());
                IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, result.getBlockPos(), level.getBlockState(pos), be, (Object)result.getDirection());
                if (cap != null) {
                    SimpleContainer newInv = new SimpleContainer(stack.has(LuggageRegistries.EXTENDED) ? 54 : 27);
                    for (ItemStack stack1 : this.getContents(stack)) {
                        for (int slot = 0; slot < cap.getSlots(); ++slot) {
                            if (cap.insertItem(slot, stack1, true) == stack1) continue;
                            stack1 = cap.insertItem(slot, stack1, false);
                            insertedAny = true;
                            break;
                        }
                        newInv.addItem(stack1);
                    }
                    if (insertedAny) {
                        stack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems((List)newInv.getItems()));
                    }
                }
            }
            return insertedAny ? InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide()) : super.use(level, player, hand);
        }
        if (result.getType() == HitResult.Type.MISS && player.isSecondaryUseActive() && this.dropContents(stack, player)) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void onLuggagePlaced(ItemStack stack, Luggage luggage) {
        if (stack.has(LuggageRegistries.EXTENDED)) {
            luggage.setExtendedInventory(true);
        }
        if (stack.has(DataComponents.CONTAINER)) {
            ((ItemContainerContents)stack.get(DataComponents.CONTAINER)).copyInto(luggage.getInventory().getItems());
            if (luggage.getInventory().getContainerSize() > 27) {
                luggage.setExtendedInventory(true);
            }
        }
        luggage.setFetchCooldown(20);
        super.onLuggagePlaced(stack, luggage);
    }

    private Iterable<ItemStack> getContents(ItemStack stack) {
        if (!stack.has(DataComponents.CONTAINER)) {
            return new ArrayList<ItemStack>();
        }
        return ((ItemContainerContents)stack.get(DataComponents.CONTAINER)).nonEmptyItems();
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        NonNullList nonnulllist = NonNullList.create();
        this.getContents(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return nonnulllist.isEmpty() ? Optional.empty() : Optional.of(new Tooltip((NonNullList<ItemStack>)nonnulllist, stack));
    }

    private boolean dropContents(ItemStack stack, Player player) {
        if (!stack.has(DataComponents.CONTAINER)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ((ItemContainerContents)stack.get(DataComponents.CONTAINER)).nonEmptyItems().forEach(stack1 -> player.drop(stack1, true));
        }
        stack.remove(DataComponents.CONTAINER);
        return true;
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        ItemUtils.onContainerDestroyed((ItemEntity)entity, this.getContents(entity.getItem()));
    }

    public record Tooltip(NonNullList<ItemStack> stacks, ItemStack stack) implements TooltipComponent
    {
    }
}

