/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity.ai;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.entity.Luggage;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class LuggagePickupItemGoal
extends Goal {
    private final Luggage luggage;
    private final PathNavigation navigation;
    @Nullable
    private ItemEntity targetItem = null;

    public LuggagePickupItemGoal(Luggage luggage) {
        this.luggage = luggage;
        this.navigation = luggage.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.luggage.getFetchCooldown() > 0 || this.luggage.isInSittingPose() || this.luggage.isInventoryOpen() || !this.navigation.isDone()) {
            return false;
        }
        List items = this.luggage.level().getEntitiesOfClass(ItemEntity.class, this.luggage.getBoundingBox().inflate(16.0), item -> (item.onGround() || item.isInWater()) && this.luggage.hasLineOfSight((Entity)item) && this.luggage.getInventory().canAddItem(item.getItem()) && item.getItem().getItem().canFitInsideContainerItems());
        items.sort(Comparator.comparingDouble(arg_0 -> ((Luggage)this.luggage).distanceToSqr(arg_0)));
        for (ItemEntity item2 : items) {
            Path toPath = this.navigation.createPath((Entity)item2, 1);
            if (toPath == null || !toPath.canReach()) continue;
            this.targetItem = item2;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.luggage.isAlive() && !this.navigation.isDone() && !this.navigation.isStuck() && this.targetItem != null && !this.targetItem.isRemoved();
    }

    public void start() {
        if (this.targetItem != null) {
            this.navigation.moveTo((Entity)this.targetItem, 1.2);
            this.luggage.setTryingToFetchItem(true);
        }
    }

    public void stop() {
        this.luggage.setTryingToFetchItem(false);
    }

    public void tick() {
        super.tick();
        if (!this.luggage.level().isClientSide() && this.targetItem != null && this.luggage.distanceToSqr(this.targetItem.position()) < 4.0) {
            ItemStack item = this.targetItem.getItem();
            if (this.luggage.getInventory().canAddItem(this.targetItem.getItem())) {
                SimpleContainer simplecontainer;
                boolean flag;
                if (this.luggage.getSoundCooldown() == 0) {
                    boolean isFood = item.has(DataComponents.FOOD);
                    this.luggage.playSound(isFood ? (SoundEvent)LuggageRegistries.LUGGAGE_EAT_FOOD.get() : (SoundEvent)LuggageRegistries.LUGGAGE_EAT_ITEM.get(), 0.5f, 1.0f + this.luggage.getRandom().nextFloat() * 0.2f);
                    this.luggage.setSoundCooldown(15);
                }
                if (!(flag = (simplecontainer = this.luggage.getInventory()).canAddItem(item))) {
                    return;
                }
                this.luggage.onItemPickup(this.targetItem);
                this.luggage.gameEvent((Holder)GameEvent.EAT, (Entity)this.luggage);
                this.luggage.take((Entity)this.targetItem, item.getCount());
                ItemStack consumedStack = simplecontainer.addItem(item);
                if (consumedStack.isEmpty()) {
                    this.targetItem.discard();
                } else {
                    item.setCount(consumedStack.getCount());
                }
            }
        }
    }
}

