/*
 * Decompiled with CFR 0.152.
 */
package io.github.lapis256.ae2_mega_things.util;

import appeng.api.stacks.AEItemKey;
import appeng.api.storage.cells.IBasicCellItem;
import appeng.me.cells.BasicCellHandler;
import appeng.me.cells.BasicCellInventory;
import io.github.lapis256.ae2_mega_things.item.AbstractDISKDrive;
import io.github.lapis256.ae2_mega_things.storage.AE2MTDISKCellHandler;
import io.github.projectet.ae2things.item.DISKDrive;
import io.github.projectet.ae2things.storage.DISKCellHandler;
import io.github.projectet.ae2things.storage.DISKCellInventory;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tH\u0007\u00a8\u0006\u000f"}, d2={"Lio/github/lapis256/ae2_mega_things/util/Utils;", "", "<init>", "()V", "isCellNestingPrevented", "", "cell", "Lappeng/api/stacks/AEItemKey;", "getItemId", "Lnet/minecraft/resources/ResourceLocation;", "item", "Lnet/minecraft/world/level/ItemLike;", "getItem", "Lnet/minecraft/world/item/Item;", "rl", "AE2MEGAThings-1.21.1"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    @JvmStatic
    public static final boolean isCellNestingPrevented(@NotNull AEItemKey cell) {
        DISKCellInventory dISKCellInventory;
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        ItemStack stack = cell.toStack();
        if (cell.getItem() instanceof IBasicCellItem) {
            BasicCellInventory basicCellInventory = BasicCellHandler.INSTANCE.getCellInventory(stack, null);
            return (basicCellInventory != null ? basicCellInventory.getUsedBytes() : 0L) > 0L;
        }
        Item item = cell.getItem();
        if (item instanceof AbstractDISKDrive) {
            Intrinsics.checkNotNull((Object)stack);
            dISKCellInventory = AE2MTDISKCellHandler.INSTANCE.getCellInventory(stack, null);
        } else if (item instanceof DISKDrive) {
            dISKCellInventory = DISKCellHandler.INSTANCE.getCellInventory(stack, null);
        } else {
            return false;
        }
        if (dISKCellInventory == null) {
            return false;
        }
        DISKCellInventory inv = dISKCellInventory;
        return !inv.getAvailableStacks().isEmpty();
    }

    @JvmStatic
    @NotNull
    public static final ResourceLocation getItemId(@NotNull ItemLike item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ResourceLocation resourceLocation = BuiltInRegistries.ITEM.getKey((Object)item.asItem());
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"getKey(...)");
        return resourceLocation;
    }

    @JvmStatic
    @NotNull
    public static final Item getItem(@NotNull ResourceLocation rl) {
        Intrinsics.checkNotNullParameter((Object)rl, (String)"rl");
        Object object = BuiltInRegistries.ITEM.get(rl);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Item)object;
    }
}

