/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import org.jetbrains.annotations.Nullable;

public class FlameEffectParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected FlameEffectParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 0.96f;
        this.sprites = sprites;
        this.quadSize *= 0.75f;
        this.hasPhysics = false;
        this.setSprite(sprites.get(level.random.nextIntBetweenInclusive(0, 99), 99));
    }

    protected FlameEffectParticle(ClientLevel level, double x, double y, double z, SpriteSet sprites) {
        super(level, x, y, z);
        this.friction = 0.96f;
        this.sprites = sprites;
        this.quadSize *= 0.75f;
        this.hasPhysics = false;
        this.setSprite(sprites.get(level.random.nextIntBetweenInclusive(0, 99), 99));
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public void tick() {
        super.tick();
        this.quadSize *= Math.clamp(((float)this.lifetime * 1.2f - (float)this.age) / ((float)this.lifetime * 1.2f) * 2.0f, 0.0f, 1.0f);
    }

    protected int getLightColor(float partialTick) {
        int i = super.getLightColor(partialTick);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += 240) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet SPRITES;

        public Provider(SpriteSet spriteProvider) {
            this.SPRITES = spriteProvider;
        }

        @Nullable
        public Particle createParticle(SimpleParticleType parameters, ClientLevel world, double x, double y, double z, double power, double i, double j) {
            return new FlameEffectParticle(world, x, y, z, this.SPRITES);
        }
    }
}

