/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.core.init.DDDamageTypes;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;
import vectorwing.farmersdelight.common.registry.ModDamageTypes;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class RawCreeperFoodItem
extends ConsumableItem {
    public RawCreeperFoodItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.raw_creeper_food", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        this.explodeRawCreeper(living);
        return super.finishUsingItem(stack, level, living);
    }

    private void explodeRawCreeper(LivingEntity living) {
        if (!living.level().isClientSide) {
            living.level().explode((Entity)living, living.getX(), living.getY(), living.getZ(), 3.0f, Level.ExplosionInteraction.BLOCK);
            living.hurt(ModDamageTypes.getSimpleDamageSource((Level)living.level(), DDDamageTypes.RAW_CREEPER), 8.0f);
            this.spawnLingeringCloud(living);
        }
    }

    private void spawnLingeringCloud(LivingEntity living) {
        Collection effects = living.getActiveEffects();
        if (!effects.isEmpty()) {
            AreaEffectCloud cloud = new AreaEffectCloud(living.level(), living.getX(), living.getY(), living.getZ());
            cloud.setRadius(2.5f);
            cloud.setRadiusOnUse(-0.5f);
            cloud.setWaitTime(10);
            cloud.setDuration(cloud.getDuration() / 2);
            cloud.setRadiusPerTick(-cloud.getRadius() / (float)cloud.getDuration());
            for (MobEffectInstance effectInstance : effects) {
                cloud.addEffect(new MobEffectInstance(effectInstance));
            }
            living.level().addFreshEntity((Entity)cloud);
            living.removeAllEffects();
        }
    }
}

