/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import java.util.List;
import java.util.Optional;
import net.azurune.runiclib.RunicLib;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.core.init.DDTags;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SpiderBubbleTeaItem
extends DrinkableItem {
    public SpiderBubbleTeaItem(Item.Properties properties, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip, false);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide) {
            List<MobEffectInstance> effectList = living.getActiveEffects().stream().filter(effect -> effect.getAmplifier() == 0 && !effect.getEffect().is(DDTags.EffectT.UNMODIFIABLE_EFFECTS)).toList();
            if (!effectList.isEmpty()) {
                Optional acidicIfExists = BuiltInRegistries.MOB_EFFECT.getHolder(RunicLib.customid((String)"bountifulfares", (String)"acidic"));
                if (acidicIfExists.isPresent() && living.hasEffect((Holder)acidicIfExists.get())) {
                    living.removeEffect((Holder)acidicIfExists.get());
                    ((ServerLevel)level).playSound(null, living.getX(), living.getY(), living.getZ(), DDSounds.ACIDIC_HISS.get(), SoundSource.PLAYERS, 1.2f, 2.0f);
                    living.addEffect(new MobEffectInstance(DDEffects.POUNCING, 2400, 1));
                } else {
                    MobEffectInstance randomEffect = effectList.get(level.getRandom().nextInt(effectList.size()));
                    living.removeEffect(randomEffect.getEffect());
                    living.addEffect(new MobEffectInstance(randomEffect.getEffect(), randomEffect.getDuration() / 2, 1));
                }
            } else {
                living.addEffect(new MobEffectInstance(DDEffects.POUNCING, 2400, 1));
            }
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.spider_bubble_tea", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.spider_bubble_tea_pouncing", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }
}

