/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.entity.misc.RancidReductionEntity;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class RancidReductionItem
extends Item
implements ProjectileItem {
    public RancidReductionItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EGG_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        if (!level.isClientSide) {
            RancidReductionEntity rancidReduction = new RancidReductionEntity(level, (LivingEntity)player);
            rancidReduction.setItem(itemStack);
            rancidReduction.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -20.0f, 0.5f, 0.5f);
            level.addFreshEntity((Entity)rancidReduction);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        player.getCooldowns().addCooldown((Item)this, 20);
        itemStack.consume(1, (LivingEntity)player);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)("tooltip." + String.valueOf((Object)this)), (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
        }
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        RancidReductionEntity rancidReduction = new RancidReductionEntity(level, pos.x(), pos.y(), pos.z());
        rancidReduction.setItem(stack);
        return rancidReduction;
    }
}

