/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.item.food_type.LengthConsumableItem;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.registry.ModEffects;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class MonsterBurgerItem
extends LengthConsumableItem {
    public MonsterBurgerItem(Item.Properties properties) {
        super(properties, 64, false, true);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        Player player;
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide && living instanceof Player && (player = (Player)living).hasEffect(ModEffects.COMFORT)) {
            int comfortDuration = player.getEffect(ModEffects.COMFORT).getDuration();
            player.addEffect(new MobEffectInstance(DDEffects.TENACITY, comfortDuration, 0));
            player.removeEffect(ModEffects.COMFORT);
        }
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.monster_burger_food", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
        }
    }
}

