/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import java.util.List;
import net.azurune.runiclib.core.register.RLMobEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.item.food_type.BiteableItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class EchoRockCandyItem
extends BiteableItem {
    public EchoRockCandyItem(Item.Properties properties, int stackSize, boolean hasPotionEffectTooltip) {
        super(properties, stackSize, hasPotionEffectTooltip);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        Player player;
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide && living instanceof Player) {
            player = (Player)living;
            player.giveExperiencePoints(6 + player.level().random.nextInt(7));
            player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP);
        }
        if (!level.isClientSide && living instanceof Player) {
            player = (Player)living;
            if (player.hasEffect(MobEffects.BLINDNESS)) {
                player.removeEffect(MobEffects.BLINDNESS);
                player.removeEffect(RLMobEffects.PERCEPTION);
                player.playSound(SoundEvents.ZOMBIE_VILLAGER_CURE, 0.5f, 1.0f);
            } else {
                player.addEffect(new MobEffectInstance(RLMobEffects.PERCEPTION, 3600, 4));
                player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 3600, 0));
            }
        }
        return stack;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            String translationKey = "tooltip.average_xp_bite";
            tooltip.add((Component)TextUtils.getTranslation((String)translationKey, (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        }
    }
}

