/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.zombified_dryad;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.azurune.runiclib.RunicLib;
import net.minecraft.client.model.DrownedModel;
import net.minecraft.client.model.ZombieModel;
import net.minecraft.client.renderer.entity.AbstractZombieRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.yirmiri.dungeonsdelight.common.entity.zombified_dryad.ZombifiedDryadEntity;
import net.yirmiri.dungeonsdelight.common.entity.zombified_dryad.ZombifiedDryadOuterLayer;
import net.yirmiri.dungeonsdelight.core.init.DDModelLayers;

public class ZombifiedDryadRenderer
extends AbstractZombieRenderer<ZombifiedDryadEntity, DrownedModel<ZombifiedDryadEntity>> {
    private static final ResourceLocation TEXTURE = RunicLib.customid((String)"dungeonsdelight", (String)"textures/entity/zombified_dryad.png");

    public ZombifiedDryadRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (ZombieModel)new DrownedModel(ctx.bakeLayer(DDModelLayers.ZOMBIFIED_DRYAD)), (ZombieModel)new DrownedModel(ctx.bakeLayer(DDModelLayers.ZOMBIFIED_DRYAD_INNER_ARMOR)), (ZombieModel)new DrownedModel(ctx.bakeLayer(DDModelLayers.ZOMBIFIED_DRYAD_OUTER_ARMOR)));
        this.addLayer(new ZombifiedDryadOuterLayer(this, ctx.getModelSet()));
    }

    public ResourceLocation getTextureLocation(Zombie entity) {
        return TEXTURE;
    }

    protected void setupRotations(ZombifiedDryadEntity entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        super.setupRotations((LivingEntity)entity, poseStack, bob, yBodyRot, partialTick, scale);
        float f = entity.getSwimAmount(partialTick);
        if (f > 0.0f) {
            float f1 = -10.0f - entity.getXRot();
            float f2 = Mth.lerp((float)f, (float)0.0f, (float)f1);
            poseStack.rotateAround(Axis.XP.rotationDegrees(f2), 0.0f, entity.getBbHeight() / 2.0f / scale, 0.0f);
        }
    }
}

