/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.entity.monster_yam;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.PotatoBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.yirmiri.dungeonsdelight.common.entity.zombified_dryad.ZombifiedDryadEntity;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import vectorwing.farmersdelight.common.block.TomatoVineBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class MonsterYamEntity
extends Monster {
    private int summonCooldown = 0;
    private int summonTimer = 0;
    private boolean isSummoning = false;

    public MonsterYamEntity(EntityType<? extends MonsterYamEntity> type, Level level) {
        super(type, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RotCropGoal(this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MAX_HEALTH, 30.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ARMOR, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.2);
    }

    public boolean doHurtTarget(Entity entity) {
        if (super.doHurtTarget(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                int duration = 6;
                if (this.level().getDifficulty() == Difficulty.NORMAL) {
                    duration = 8;
                } else if (this.level().getDifficulty() == Difficulty.HARD) {
                    duration = 12;
                }
                living.addEffect(new MobEffectInstance(DDEffects.PUTRID_SCENT, duration * 20, 0), (Entity)this);
            }
            return true;
        }
        return false;
    }

    public boolean isSummoning() {
        return this.isSummoning;
    }

    public void setSummoning(boolean summoning) {
        this.isSummoning = summoning;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.summonCooldown > 0) {
                --this.summonCooldown;
            }
            List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(6.0), Entity::isAlive);
            for (LivingEntity livingEntity : list) {
                if (!livingEntity.isAlive() || !livingEntity.getType().is(EntityTypeTags.UNDEAD) || livingEntity == this) continue;
                livingEntity.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 40, 0, true, false));
                livingEntity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 40, 0, true, false));
            }
            if (this.getTarget() instanceof Player && this.summonCooldown == 0) {
                if (!this.isSummoning()) {
                    this.setSummoning(true);
                    this.summonTimer = 40;
                    this.setDeltaMovement(Vec3.ZERO);
                    this.getNavigation().stop();
                    this.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), 0.0);
                } else {
                    --this.summonTimer;
                    this.setDeltaMovement(Vec3.ZERO);
                    this.getNavigation().stop();
                    this.getMoveControl().setWantedPosition(this.getX(), this.getY(), this.getZ(), 0.0);
                    if (this.summonTimer <= 0) {
                        List nearbyZombies = this.level().getEntitiesOfClass(ZombifiedDryadEntity.class, this.getBoundingBox().inflate(24.0));
                        if (nearbyZombies.isEmpty()) {
                            for (int i = 0; i < 3; ++i) {
                                ZombifiedDryadEntity zombie = (ZombifiedDryadEntity)DDEntities.ZOMBIFIED_DRYAD.get().create(this.level());
                                if (zombie == null) continue;
                                BlockPos spawnPos = this.blockPosition().offset((int)((this.random.nextDouble() - 0.5) * 4.0), 0, (int)((this.random.nextDouble() - 0.5) * 4.0));
                                zombie.moveTo((double)spawnPos.getX() + 0.5, spawnPos.getY(), (double)spawnPos.getZ() + 0.5, this.random.nextFloat() * 360.0f, 0.0f);
                                this.level().addFreshEntity((Entity)zombie);
                                if (this.level().getDifficulty() != Difficulty.HARD) continue;
                                this.level().addFreshEntity((Entity)zombie);
                            }
                            ((ServerLevel)this.level()).sendParticles((ParticleOptions)DDParticles.LIVING_FLAME.get(), this.getX(), this.getY() + 1.0, this.getZ(), 10, 0.5, 0.5, 0.5, 0.1);
                        }
                        this.setSummoning(false);
                        this.summonCooldown = 600;
                    }
                }
            } else if (this.isSummoning()) {
                this.setSummoning(false);
                this.summonTimer = 0;
            }
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        Player player;
        Entity entity;
        if (this.isSummoning()) {
            this.setSummoning(false);
            this.summonTimer = 0;
            this.summonCooldown = 400;
        }
        if ((entity = source.getEntity()) instanceof Player && ((player = (Player)entity).getMainHandItem().is(ItemTags.HOES) || player.getMainHandItem().is(ModTags.KNIVES))) {
            amount *= 2.0f;
        }
        return super.hurt(source, amount);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    protected SoundEvent getAmbientSound() {
        return DDSounds.MONSTER_YAM_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return DDSounds.MONSTER_YAM_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return DDSounds.MONSTER_YAM_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return DDSounds.MONSTER_YAM_STEP.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound(this.getStepSound(), 0.15f, 1.0f);
    }

    public static class RotCropGoal
    extends Goal {
        private final MonsterYamEntity entity;
        private final double speed;
        private BlockPos targetCrop;

        public RotCropGoal(MonsterYamEntity entity, double speed) {
            this.entity = entity;
            this.speed = speed;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            BlockPos entityPos = this.entity.blockPosition();
            if (!this.shouldSearch()) {
                return false;
            }
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)entityPos.offset(-5, -1, -5), (BlockPos)entityPos.offset(5, 1, 5))) {
                BlockState state = this.entity.level().getBlockState(pos);
                if (!this.canCropRot(state) || this.entity.getNavigation().createPath(pos, 0) == null) continue;
                this.targetCrop = pos.immutable();
                return true;
            }
            return false;
        }

        public boolean canContinueToUse() {
            return this.targetCrop != null && !this.entity.getNavigation().isDone();
        }

        public void start() {
            if (this.targetCrop != null) {
                this.entity.getNavigation().moveTo((double)this.targetCrop.getX() + 0.5, (double)this.targetCrop.getY(), (double)this.targetCrop.getZ() + 0.5, this.speed);
            }
        }

        public void tick() {
            Vec3 targetVec;
            if (this.targetCrop != null && this.entity.distanceToSqr(targetVec = Vec3.atCenterOf((Vec3i)this.targetCrop)) < 2.25) {
                if (this.canCropRot(this.entity.level().getBlockState(this.targetCrop))) {
                    this.rotCrop(this.targetCrop);
                }
                this.targetCrop = null;
            }
        }

        private boolean shouldSearch() {
            return this.entity.getRandom().nextInt(20) == 0;
        }

        private boolean canCropRot(BlockState state) {
            Block block = state.getBlock();
            if (!(block instanceof CropBlock)) {
                return false;
            }
            CropBlock cropBlock = (CropBlock)block;
            if (!cropBlock.isMaxAge(state)) {
                return false;
            }
            if (cropBlock instanceof TomatoVineBlock) {
                return (Boolean)state.getValue((Property)TomatoVineBlock.ROPELOGGED) == false;
            }
            return true;
        }

        private void rotCrop(BlockPos pos) {
            Level level = this.entity.level();
            BlockState oldState = level.getBlockState(pos);
            BlockState newState = DDBlocks.ROTTEN_CROP.get().defaultBlockState();
            if (oldState.getBlock() instanceof PotatoBlock) {
                newState = DDBlocks.ROTTEN_POTATOES.get().defaultBlockState();
            } else if (oldState.getBlock() instanceof TomatoVineBlock) {
                newState = DDBlocks.ROTTEN_TOMATOES.get().defaultBlockState();
            }
            level.setBlockAndUpdate(pos, newState);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, oldState), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 20, 0.3, 0.3, 0.3, 0.05);
            }
            level.playSound(null, pos, SoundEvents.CROP_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

