/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.monster_pot;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.EnumSet;
import net.minecraft.util.StringRepresentable;

public enum MonsterPotRecipeBookTab implements StringRepresentable
{
    MONSTER_MEALS("monster_meals"),
    MONSTER_DRINKS("monster_drinks"),
    MONSTER_MISC("monster_misc");

    public static final Codec<MonsterPotRecipeBookTab> CODEC;
    public final String name;

    private MonsterPotRecipeBookTab(String name) {
        this.name = name;
    }

    public static MonsterPotRecipeBookTab findByName(String name) {
        for (MonsterPotRecipeBookTab value : MonsterPotRecipeBookTab.values()) {
            if (!value.name.equals(name)) continue;
            return value;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = Codec.STRING.flatXmap(s -> {
            MonsterPotRecipeBookTab tab = MonsterPotRecipeBookTab.findByName(s);
            if (tab == null) {
                return DataResult.error(() -> "Optional field 'recipe_book_tab' does not match any valid tab. If defined, must be one of the following: " + String.valueOf(EnumSet.allOf(MonsterPotRecipeBookTab.class)));
            }
            return DataResult.success((Object)((Object)tab));
        }, tab -> DataResult.success((Object)tab.toString()));
    }
}

