/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.yirmiri.dungeonsdelight.common.block.entity.DungeonStoveBlockEntity;
import vectorwing.farmersdelight.common.block.StoveBlock;

public class DungeonStoveBlockEntityRenderer
implements BlockEntityRenderer<DungeonStoveBlockEntity> {
    public DungeonStoveBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DungeonStoveBlockEntity dungeonStoveBlockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction direction = ((Direction)dungeonStoveBlockEntity.getBlockState().getValue((Property)StoveBlock.FACING)).getOpposite();
        ItemStackHandler inventory = dungeonStoveBlockEntity.getInventory();
        int posLong = (int)dungeonStoveBlockEntity.getBlockPos().asLong();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stoveStack = inventory.getStackInSlot(i);
            if (stoveStack.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.5, 1.02, 0.5);
            float f = -direction.toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(f));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            Vec2 itemOffset = dungeonStoveBlockEntity.getStoveItemOffset(i);
            poseStack.translate((double)itemOffset.x, (double)itemOffset.y, 0.0);
            poseStack.scale(0.375f, 0.375f, 0.375f);
            if (dungeonStoveBlockEntity.getLevel() != null) {
                Minecraft.getInstance().getItemRenderer().renderStatic(stoveStack, ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)dungeonStoveBlockEntity.getLevel(), (BlockPos)dungeonStoveBlockEntity.getBlockPos().above()), combinedOverlayIn, poseStack, buffer, dungeonStoveBlockEntity.getLevel(), posLong + i);
            }
            poseStack.popPose();
        }
    }
}

