/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.common.block.LivingTorchBlock;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;

public class WallLivingTorchBlock
extends LivingTorchBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0), (Object)Direction.WEST, (Object)Block.box((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5)));

    public WallLivingTorchBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    @Override
    public VoxelShape getShape(BlockState p_58152_, BlockGetter p_58153_, BlockPos p_58154_, CollisionContext p_58155_) {
        return WallLivingTorchBlock.getShape(p_58152_);
    }

    public static VoxelShape getShape(BlockState p_58157_) {
        return AABBS.get(p_58157_.getValue((Property)FACING));
    }

    @Override
    public boolean canSurvive(BlockState p_58133_, LevelReader p_58134_, BlockPos p_58135_) {
        Direction $$3 = (Direction)p_58133_.getValue((Property)FACING);
        BlockPos $$4 = p_58135_.relative($$3.getOpposite());
        BlockState $$5 = p_58134_.getBlockState($$4);
        return $$5.isFaceSturdy((BlockGetter)p_58134_, $$4, $$3);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_58126_) {
        Direction[] $$4;
        BlockState $$1 = this.defaultBlockState();
        Level $$2 = p_58126_.getLevel();
        BlockPos $$3 = p_58126_.getClickedPos();
        Direction[] var6 = $$4 = p_58126_.getNearestLookingDirections();
        int var7 = $$4.length;
        for (int var8 = 0; var8 < var7; ++var8) {
            Direction $$6;
            Direction $$5 = var6[var8];
            if (!$$5.getAxis().isHorizontal() || !($$1 = (BlockState)$$1.setValue((Property)FACING, (Comparable)($$6 = $$5.getOpposite()))).canSurvive((LevelReader)$$2, $$3)) continue;
            return $$1;
        }
        return null;
    }

    @Override
    public BlockState updateShape(BlockState p_58143_, Direction p_58144_, BlockState p_58145_, LevelAccessor p_58146_, BlockPos p_58147_, BlockPos p_58148_) {
        return p_58144_.getOpposite() == p_58143_.getValue((Property)FACING) && !p_58143_.canSurvive((LevelReader)p_58146_, p_58147_) ? Blocks.AIR.defaultBlockState() : p_58143_;
    }

    @Override
    public void animateTick(BlockState p_222660_, Level p_222661_, BlockPos p_222662_, RandomSource p_222663_) {
        Direction $$4 = (Direction)p_222660_.getValue((Property)FACING);
        double $$5 = (double)p_222662_.getX() + 0.5;
        double $$6 = (double)p_222662_.getY() + 0.7;
        double $$7 = (double)p_222662_.getZ() + 0.5;
        double $$8 = 0.22;
        double $$9 = 0.27;
        Direction $$10 = $$4.getOpposite();
        p_222661_.addParticle((ParticleOptions)ParticleTypes.SMOKE, $$5 + 0.27 * (double)$$10.getStepX(), $$6 + 0.22, $$7 + 0.27 * (double)$$10.getStepZ(), 0.0, 0.0, 0.0);
        p_222661_.addParticle((ParticleOptions)DDParticles.LIVING_FLAME.get(), $$5 + 0.27 * (double)$$10.getStepX(), $$6 + 0.22, $$7 + 0.27 * (double)$$10.getStepZ(), 0.0, 0.0, 0.0);
    }

    public BlockState rotate(BlockState p_58140_, Rotation p_58141_) {
        return (BlockState)p_58140_.setValue((Property)FACING, (Comparable)p_58141_.rotate((Direction)p_58140_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_58137_, Mirror p_58138_) {
        return p_58137_.rotate(p_58138_.getRotation((Direction)p_58137_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58150_) {
        p_58150_.add(new Property[]{FACING});
    }
}

