/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.floralench.blocks.wither_variant;

import com.cozary.floralench.blocks.base.VineBushBlock;
import com.cozary.floralench.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WitherVineBushBlock
extends VineBushBlock {
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        VoxelShape voxelshape = this.getShape(stateIn, (BlockGetter)worldIn, pos, CollisionContext.empty());
        Vec3 vector3d = voxelshape.bounds().getCenter();
        double d0 = (double)pos.getX() + vector3d.x;
        for (int i = 0; i < 4; ++i) {
            if (!rand.nextBoolean()) continue;
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + rand.nextDouble() / 5.0, (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        LivingEntity livingentity;
        if (!worldIn.isClientSide && worldIn.getDifficulty() != Difficulty.PEACEFUL && entityIn instanceof LivingEntity && !(livingentity = (LivingEntity)entityIn).isInvulnerableTo(worldIn.damageSources().wither())) {
            livingentity.addEffect(new MobEffectInstance(MobEffects.WITHER, 40));
        }
    }

    public ItemStack getCloneItemStack(LevelReader worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.WITHER_ROSE_BUSH_ITEM.get());
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        boolean flag;
        int i = (Integer)state.getValue((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.getMainHandItem().getItem() == Items.BONE_MEAL) {
            return InteractionResult.PASS;
        }
        if (i == 2) {
            int j = 1 + worldIn.random.nextInt(4);
            WitherVineBushBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.WITHER_ROSE, j));
            worldIn.playSound(null, pos, SoundEvents.GRASS_FALL, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.random.nextFloat() * 0.4f);
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        if (i == 3) {
            int j = 1 + worldIn.random.nextInt(3);
            WitherVineBushBlock.popResource((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.WITHER_ROSE_VINE_ITEM.get(), j));
            worldIn.playSound(null, pos, SoundEvents.GRASS_FALL, SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.random.nextFloat() * 0.4f);
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            return InteractionResult.sidedSuccess((boolean)worldIn.isClientSide);
        }
        return super.useWithoutItem(state, worldIn, pos, player, hit);
    }
}

