/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.floralench.blocks.wither_variant;

import com.cozary.floralench.blocks.base.LargePot;
import com.cozary.floralench.init.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeDoubleWitherRosePot
extends LargePot {
    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack itemstack = player.getMainHandItem();
        Item item = itemstack.getItem();
        ItemStack item1 = Items.WITHER_ROSE.getDefaultInstance();
        Direction direction1 = (Direction)state.getValue((Property)FACING);
        if (!worldIn.isClientSide && item == Items.AIR) {
            worldIn.setBlockAndUpdate(pos, (BlockState)ModBlocks.LARGE_WITHER_ROSE_POT.get().defaultBlockState().setValue((Property)LargePot.FACING, (Comparable)direction1));
            player.setItemInHand(InteractionHand.MAIN_HAND, item1);
        }
        return InteractionResult.CONSUME;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        VoxelShape voxelshape = this.getShape(stateIn, (BlockGetter)worldIn, pos, CollisionContext.empty());
        Vec3 vector3d = voxelshape.bounds().getCenter();
        double d0 = (double)pos.getX() + vector3d.x;
        for (int i = 0; i < 3; ++i) {
            if (!rand.nextBoolean()) continue;
            worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + rand.nextDouble() / 5.0, (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    public void stepOn(Level worldIn, BlockPos pos, BlockState blockState, Entity entityIn) {
        LivingEntity livingentity;
        if (!worldIn.isClientSide && worldIn.getDifficulty() != Difficulty.PEACEFUL && entityIn instanceof LivingEntity && !(livingentity = (LivingEntity)entityIn).isInvulnerableTo(worldIn.damageSources().wither())) {
            livingentity.addEffect(new MobEffectInstance(MobEffects.WITHER, 40));
        }
        super.stepOn(worldIn, pos, blockState, entityIn);
    }
}

