/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.floralench.blocks.pots.special;

import com.cozary.floralench.blocks.base.LargePot;
import com.cozary.floralench.init.ModBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DancingSunflower
extends LargePot {
    Optional<BlockPos> jukeboxPosition;
    BlockState jukebox;

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        ItemStack itemstack = player.getMainHandItem();
        Item item = itemstack.getItem();
        ItemStack item1 = Items.SUNFLOWER.getDefaultInstance();
        Direction direction1 = (Direction)state.getValue((Property)FACING);
        if (!worldIn.isClientSide && item == Items.AIR) {
            worldIn.setBlockAndUpdate(pos, (BlockState)ModBlocks.LARGE_POT.get().defaultBlockState().setValue((Property)LargePot.FACING, (Comparable)direction1));
            player.setItemInHand(InteractionHand.MAIN_HAND, item1);
        }
        return InteractionResult.CONSUME;
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        Direction direction1 = (Direction)state.getValue((Property)FACING);
        if (!worldIn.isClientSide) {
            this.jukeboxPosition = this.findNearestRepellent(worldIn, pos);
            if (this.jukeboxPosition.isPresent()) {
                this.jukebox = worldIn.getBlockState(this.jukeboxPosition.get());
                if (!((Boolean)this.jukebox.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue() && worldIn.getBlockState(this.jukeboxPosition.get()).is(Blocks.JUKEBOX) && this.jukeboxPosition.get().closerThan((Vec3i)pos, 11.0)) {
                    worldIn.setBlockAndUpdate(pos, (BlockState)ModBlocks.LARGE_SUNFLOWER_POT.get().defaultBlockState().setValue((Property)LargePot.FACING, (Comparable)direction1));
                }
            }
        }
    }

    private Optional<BlockPos> findNearestRepellent(ServerLevel p_26665_, BlockPos pos) {
        return BlockPos.findClosestMatch((BlockPos)pos, (int)11, (int)0, block -> p_26665_.getBlockState(block).is(Blocks.JUKEBOX));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }
}

