/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.floralench.blocks.base;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VineBushBlock
extends SweetBerryBushBlock {
    private static final VoxelShape BUSHLING_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0);
    private static final VoxelShape HALF_GROW_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final VoxelShape GROW_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public VineBushBlock() {
        super(BlockBehaviour.Properties.of().noCollission().randomTicks().strength(0.2f).sound(SoundType.SWEET_BERRY_BUSH).mapColor(MapColor.PLANT).ignitedByLava().pushReaction(PushReaction.DESTROY));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if ((Integer)state.getValue((Property)AGE) == 0) {
            return BUSHLING_SHAPE;
        }
        if ((Integer)state.getValue((Property)AGE) == 1 || (Integer)state.getValue((Property)AGE) == 2) {
            return HALF_GROW_SHAPE;
        }
        return (Integer)state.getValue((Property)AGE) == 3 ? GROW_SHAPE : super.getShape(state, worldIn, pos, context);
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.getType() != EntityType.FOX && entityIn.getType() != EntityType.BEE) {
            entityIn.makeStuckInBlock(state, new Vec3((double)0.9f, 0.85, (double)0.9f));
        }
    }
}

