/*
 * Decompiled with CFR 0.152.
 */
package com.cozary.floralench;

import com.cozary.floralench.init.ModItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;

@EventBusSubscriber(modid="floralench", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class EventHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderHeldPot(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        PlayerRenderer render = event.getRenderer();
        PlayerModel model = (PlayerModel)render.getModel();
        Pose pose = player.getPose();
        if (!ModList.get().isLoaded("obfuscate") && (pose != Pose.SWIMMING && pose != Pose.FALL_FLYING && pose != Pose.SLEEPING && player != null && player.getMainHandItem().getItem().toString().contains("large") && player.getMainHandItem().getItem().toString().contains("pot") || player.getMainHandItem().getItem() == ModItems.DANCING_SUNFLOWER.get())) {
            model.leftArm.visible = false;
            model.leftSleeve.visible = false;
            model.rightArm.visible = false;
            model.rightSleeve.visible = false;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void holdPotPost(RenderPlayerEvent.Post event) {
        Player player = event.getEntity();
        PlayerModel model = (PlayerModel)event.getRenderer().getModel();
        if (player != null && player.getMainHandItem().getItem().toString().contains("large") && player.getMainHandItem().getItem().toString().contains("pot") || player.getMainHandItem().getItem() == ModItems.DANCING_SUNFLOWER.get()) {
            EventHandler.renderArmModelHoldingPot((PlayerModel<AbstractClientPlayer>)model, player, (RenderPlayerEvent)event);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void renderArmModelHoldingPot(PlayerModel<AbstractClientPlayer> model, Player player, RenderPlayerEvent event) {
        PoseStack matrix = event.getPoseStack();
        VertexConsumer buffer = event.getMultiBufferSource().getBuffer(model.renderType(((AbstractClientPlayer)player).getSkin().texture()));
        int light = event.getPackedLight();
        int texture = OverlayTexture.NO_OVERLAY;
        Pose pose = player.getPose();
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            return;
        }
        if (!ModList.get().isLoaded("obfuscate")) {
            model.rightArm.x = -Mth.cos((float)((float)Math.toRadians(player.yBodyRot))) * 4.2f;
            model.rightArm.y = player.isCrouching() ? 16.5f : 20.5f;
            model.rightArm.z = -Mth.sin((float)((float)Math.toRadians(player.yBodyRot))) * 5.0f;
            model.rightArm.xRot = 9.0f + model.rightArm.xRot * 0.5f - 0.31415927f;
            model.rightArm.yRot = (float)(-Math.toRadians(player.yBodyRot));
            model.rightArm.zRot = 0.0f;
            model.leftArm.x = Mth.cos((float)((float)Math.toRadians(player.yBodyRot))) * 4.2f;
            model.leftArm.y = player.isCrouching() ? 16.5f : 20.5f;
            model.leftArm.z = Mth.sin((float)((float)Math.toRadians(player.yBodyRot))) * 5.0f;
            model.leftArm.xRot = model.rightArm.xRot;
            model.leftArm.yRot = (float)(-Math.toRadians(player.yBodyRot));
            model.leftArm.zRot = 0.0f;
            model.rightArm.visible = true;
            model.leftArm.visible = true;
            model.rightArm.render(matrix, buffer, light, texture);
            model.leftArm.render(matrix, buffer, light, texture);
            model.rightSleeve.x = -Mth.cos((float)((float)Math.toRadians(player.yBodyRot))) * 4.2f;
            model.rightSleeve.y = player.isCrouching() ? 16.5f : 20.5f;
            model.rightSleeve.z = -Mth.sin((float)((float)Math.toRadians(player.yBodyRot))) * 5.0f;
            model.rightSleeve.xRot = 9.0f + model.rightSleeve.xRot * 0.5f - 0.31415927f;
            model.rightSleeve.yRot = (float)(-Math.toRadians(player.yBodyRot));
            model.rightSleeve.zRot = 0.0f;
            model.leftSleeve.x = Mth.cos((float)((float)Math.toRadians(player.yBodyRot))) * 4.2f;
            model.leftSleeve.y = player.isCrouching() ? 16.5f : 20.5f;
            model.leftSleeve.z = Mth.sin((float)((float)Math.toRadians(player.yBodyRot))) * 5.0f;
            model.leftSleeve.xRot = model.rightSleeve.xRot;
            model.leftSleeve.yRot = (float)(-Math.toRadians(player.yBodyRot));
            model.leftSleeve.zRot = 0.0f;
            model.rightSleeve.visible = true;
            model.leftSleeve.visible = true;
            model.rightSleeve.render(matrix, buffer, light, texture);
            model.leftSleeve.render(matrix, buffer, light, texture);
        }
    }
}

