/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.salju.kobolds.compat.SpearsManager;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.entity.ai.KoboldAttackSelector;
import net.salju.kobolds.entity.ai.KoboldBowGoal;
import net.salju.kobolds.entity.ai.KoboldCrossbowGoal;
import net.salju.kobolds.entity.ai.KoboldMeleeGoal;
import net.salju.kobolds.entity.ai.KoboldPotionGoal;
import net.salju.kobolds.entity.ai.KoboldRevengeGoal;
import net.salju.kobolds.entity.ai.KoboldShieldGoal;
import net.salju.kobolds.entity.ai.KoboldTargetGoal;
import net.salju.kobolds.entity.ai.KoboldTridentGoal;
import net.salju.kobolds.events.KoboldsManager;
import net.salju.kobolds.init.KoboldsItems;
import net.salju.kobolds.init.KoboldsTags;

public class KoboldWarrior
extends AbstractKoboldEntity {
    public KoboldWarrior(EntityType<KoboldWarrior> type, Level world) {
        super(type, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        KoboldsManager.addPirateGoals(this);
        this.targetSelector.addGoal(0, (Goal)new KoboldRevengeGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldPotionGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldShieldGoal(this));
        this.goalSelector.addGoal(1, (Goal)new KoboldTridentGoal(this, 1.0, 40, 12.0f));
        this.goalSelector.addGoal(1, new KoboldCrossbowGoal<KoboldWarrior>(this, 1.0, 12.0f));
        this.goalSelector.addGoal(1, new KoboldBowGoal<KoboldWarrior>(this, 1.0, 20, 15.0f));
        this.goalSelector.addGoal(2, new KoboldMeleeGoal<KoboldWarrior>(this, 1.2, false));
        this.targetSelector.addGoal(2, new KoboldTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, new KoboldAttackSelector(this)));
    }

    public boolean doHurtTarget(Entity target) {
        boolean check = super.doHurtTarget(target);
        if (check && !target.isAlive() && this.isSpear(this.getMainHandItem())) {
            this.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 600, 0));
        }
        return check;
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource randy, DifficultyInstance souls) {
        if (Math.random() >= 0.25 && SpearsManager.shouldSpawnWithSpears()) {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_SPEAR.get()));
        } else {
            this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)KoboldsItems.KOBOLD_IRON_AXE.get()));
        }
        this.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
        super.populateDefaultEquipmentSlots(randy, souls);
    }

    @Override
    public boolean isPreferredWeapon(ItemStack stack) {
        return stack.is(KoboldsTags.WAR);
    }
}

