/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.salju.kobolds.client.model.KoboldArmorModel;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.client.renderer.layers.KoboldItemInHandLayer;
import net.salju.kobolds.entity.AbstractKoboldEntity;
import net.salju.kobolds.init.KoboldsClient;

public abstract class AbstractKoboldRenderer
extends MobRenderer<AbstractKoboldEntity, KoboldModel<AbstractKoboldEntity>> {
    public AbstractKoboldRenderer(EntityRendererProvider.Context context, KoboldModel<AbstractKoboldEntity> model, boolean check) {
        super(context, model, 0.36f);
        if (check) {
            this.addLayer((RenderLayer)new KoboldItemInHandLayer(this, context.getItemInHandRenderer()));
            this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_INNER)), (HumanoidModel)new KoboldArmorModel(context.bakeLayer(KoboldsClient.KOBOLD_ARMOR_OUTER)), context.getModelManager()));
        }
    }

    public ResourceLocation getTextureLocation(AbstractKoboldEntity kobold) {
        return ResourceLocation.fromNamespaceAndPath((String)"kobolds", (String)("textures/entity/" + this.getKoboldType(kobold) + ".png"));
    }

    public void render(AbstractKoboldEntity kobold, float f1, float f2, PoseStack pose, MultiBufferSource buffer, int i) {
        pose.pushPose();
        pose.translate(-0.025, 0.0, 0.0);
        float scale = kobold.isBaby() ? 0.475f : 0.875f;
        pose.scale(scale, scale, scale);
        super.render((LivingEntity)kobold, f1, f2, pose, buffer, i);
        pose.popPose();
    }

    public abstract String getKoboldType(AbstractKoboldEntity var1);
}

