/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class RascalModel<T extends AbstractKoboldEntity>
extends KoboldModel<T> {
    public final ModelPart bag;

    public RascalModel(ModelPart root) {
        super(root);
        this.bag = root.getChild("bag");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = KoboldModel.createMesh(new CubeDeformation(0.0f), 0.0f);
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("bag", CubeListBuilder.create().texOffs(26, 30).addBox(-1.0f, 0.0f, 2.0f, 5.0f, 7.0f, 4.0f, new CubeDeformation(0.001f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        root.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(33, 7).addBox(-5.0f, -0.85f, -1.5f, 8.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)6.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack pose, VertexConsumer buffer, int light, int overlay, int color) {
        super.renderToBuffer(pose, buffer, light, overlay, color);
        this.bag.render(pose, buffer, light, overlay, color);
    }

    @Override
    public void translateToHand(HumanoidArm arm, PoseStack pose) {
        switch (arm) {
            case LEFT: 
            case RIGHT: {
                this.rightArm.translateAndRotate(pose);
                pose.translate(-0.045, 0.096, 0.0);
                pose.scale(0.75f, 0.75f, 0.75f);
            }
        }
    }

    @Override
    protected void defaultPose(T kobold, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.defaultPose(kobold, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.leftArm.xRot = -0.7854f;
        this.leftArm.yRot = 0.0f;
        this.leftArm.zRot = 0.0f;
    }

    @Override
    protected void poseArms(T kobold, Item target, ModelPart mainArm, ModelPart offArm) {
        if (kobold.isAggressive()) {
            this.rightArm.xRot = -2.0944f;
            this.rightArm.yRot = 0.1745f;
        }
    }
}

