/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.client;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.salju.kobolds.client.model.KoboldModel;
import net.salju.kobolds.entity.AbstractKoboldEntity;

public class SpearAnimations {
    public static <T extends AbstractKoboldEntity> void spearAttackAnimation(KoboldModel<T> model, ModelPart mainArm) {
        float f = model.attackTime;
        model.rightArm.yRot -= model.body.yRot;
        model.leftArm.yRot -= model.body.yRot;
        model.leftArm.xRot -= model.body.yRot;
        float f1 = SpearAnimations.inOutSine(SpearAnimations.progress(f, 0.0f, 0.05f));
        float f2 = SpearAnimations.inQuad(SpearAnimations.progress(f, 0.05f, 0.2f));
        float f3 = SpearAnimations.inOutExpo(SpearAnimations.progress(f, 0.4f, 1.0f));
        mainArm.xRot += (90.0f * f1 - 120.0f * f2 + 30.0f * f3) * ((float)Math.PI / 180);
    }

    private static float progress(float f, float min, float max) {
        return Mth.clamp((float)Mth.inverseLerp((float)f, (float)min, (float)max), (float)0.0f, (float)1.0f);
    }

    public static float inOutSine(float f) {
        return -(Mth.cos((float)((float)Math.PI * f)) - 1.0f) / 2.0f;
    }

    public static float inQuad(float f) {
        return f * f;
    }

    public static float inOutExpo(float f) {
        if (f < 0.5f) {
            return f == 0.0f ? 0.0f : (float)(Math.pow(2.0, 20.0 * (double)f - 10.0) / 2.0);
        }
        return f == 1.0f ? 1.0f : (float)((2.0 - Math.pow(2.0, -20.0 * (double)f + 10.0)) / 2.0);
    }
}

