/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.entity_filter;

import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGMenuTypes;
import com.jesz.createdieselgenerators.content.entity_filter.EntityAttribute;
import com.jesz.createdieselgenerators.content.entity_filter.EntityFilterMenu;
import com.simibubi.create.AllDataComponents;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.logistics.filter.AttributeFilterWhitelistMode;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EntityFilterItem
extends Item {
    public EntityFilterItem(Item.Properties properties) {
        super(properties);
    }

    static List<EntityAttribute.EntityAttributeEntry> getEntries(ItemStack stack) {
        return (List)stack.getOrDefault(CDGDataComponents.ENTITY_FILTER_MATCHED_ATTRIBUTES, Collections.emptyList());
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (AllKeys.shiftDown()) {
            return;
        }
        List<Component> makeSummary = this.makeSummary(stack);
        if (makeSummary.isEmpty()) {
            return;
        }
        tooltipComponents.add(CommonComponents.SPACE);
        tooltipComponents.addAll(makeSummary);
    }

    private List<Component> makeSummary(ItemStack stack) {
        ArrayList<Component> list = new ArrayList<Component>();
        AttributeFilterWhitelistMode whitelistMode = (AttributeFilterWhitelistMode)stack.get(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE);
        list.add((Component)(whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_conjunctive", (Object[])new Object[0]) : (whitelistMode == AttributeFilterWhitelistMode.WHITELIST_DISJ ? CreateLang.translateDirect((String)"gui.attribute_filter.allow_list_disjunctive", (Object[])new Object[0]) : CreateLang.translateDirect((String)"gui.attribute_filter.deny_list", (Object[])new Object[0]))).withStyle(ChatFormatting.GOLD));
        int count = 0;
        for (EntityAttribute.EntityAttributeEntry entry : EntityFilterItem.getEntries(stack)) {
            if (count > 5) {
                list.add((Component)Component.literal((String)"- ...").withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            list.add((Component)Component.literal((String)"- ").append(entry.attribute().format(entry.inverted())));
            ++count;
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        return list;
    }

    public static boolean test(ItemStack stack, Entity entity) {
        AttributeFilterWhitelistMode whitelistMode = (AttributeFilterWhitelistMode)stack.getOrDefault(AllDataComponents.ATTRIBUTE_FILTER_WHITELIST_MODE, (Object)AttributeFilterWhitelistMode.WHITELIST_DISJ);
        AtomicBoolean passed = new AtomicBoolean(false);
        if (whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ) {
            passed.set(true);
        }
        EntityFilterItem.getEntries(stack).forEach(entry -> {
            boolean currentAttributePassed = entry.attribute().test(entity) ^ entry.inverted();
            if (whitelistMode != AttributeFilterWhitelistMode.WHITELIST_CONJ && !passed.get()) {
                passed.set(currentAttributePassed);
            }
            if (whitelistMode == AttributeFilterWhitelistMode.WHITELIST_CONJ) {
                passed.set(currentAttributePassed && passed.get());
            }
        });
        return passed.get() ^ whitelistMode == AttributeFilterWhitelistMode.BLACKLIST;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        if (player.isShiftKeyDown() || hand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.pass((Object)stackInHand);
        }
        if (level.isClientSide || !(player instanceof ServerPlayer)) {
            return InteractionResultHolder.success((Object)stackInHand);
        }
        ServerPlayer sp = (ServerPlayer)player;
        sp.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new EntityFilterMenu((MenuType)CDGMenuTypes.ENTITY_FILTER.get(), id, inventory, player1.getMainHandItem()), this.getDescription()), buf -> ItemStack.STREAM_CODEC.encode(buf, (Object)stackInHand));
        return InteractionResultHolder.success((Object)stackInHand);
    }
}

