/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.packet;

import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.packet.PacketStreamCodecs;

public record BeamPacket(Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<BeamPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packagedauto:beam"));
    public static final StreamCodec<RegistryFriendlyByteBuf, BeamPacket> STREAM_CODEC = StreamCodec.composite(PacketStreamCodecs.VEC3, BeamPacket::source, (StreamCodec)PacketStreamCodecs.VEC3.apply(ByteBufCodecs.list()), BeamPacket::deltas, PacketStreamCodecs.UNSIGNED_MEDIUM, BeamPacket::color, (StreamCodec)ByteBufCodecs.UNSIGNED_SHORT, BeamPacket::lifetime, (StreamCodec)ByteBufCodecs.BOOL, BeamPacket::fadeout, BeamPacket::new);

    public CustomPacketPayload.Type<BeamPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> WorldOverlayRenderer.INSTANCE.addBeams(this.source, this.deltas, this.color, this.lifetime, this.fadeout));
    }

    public static void sendBeams(ServerLevel level, Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout, double range) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)source.x, (double)source.y, (double)source.z, (double)range, (CustomPacketPayload)new BeamPacket(source, deltas, color, lifetime, fadeout), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendBeams(ServerPlayer player, Vec3 source, List<Vec3> deltas, int color, int lifetime, boolean fadeout) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BeamPacket(source, deltas, color, lifetime, fadeout), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

