/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.Collection;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.UnpackagerItemHandlerWrapper;
import thelm.packagedauto.util.MiscHelper;

public class UnpackagerItemHandler
extends BaseItemHandler<UnpackagerBlockEntity> {
    public UnpackagerItemHandler(UnpackagerBlockEntity blockEntity) {
        super(blockEntity, 11);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot == 9) {
            this.updateRecipeList();
        } else if (slot != 10) {
            this.clearRejectedIndexes();
        }
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        if (slot == 9) {
            return 1;
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 9 -> stack.has(PackagedAutoDataComponents.RECIPE_LIST);
            case 10 -> {
                if (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                    yield true;
                }
                yield false;
            }
            default -> MiscHelper.INSTANCE.isPackage(stack);
        };
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        super.load(nbt, registries);
        this.updateRecipeList();
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new UnpackagerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int get(int id) {
        if (id < 10) {
            return ((UnpackagerBlockEntity)this.blockEntity).trackers[id].getSyncValue();
        }
        return switch (id) {
            case 10 -> {
                if (((UnpackagerBlockEntity)this.blockEntity).blocking) {
                    yield 1;
                }
                yield 0;
            }
            case 11 -> ((UnpackagerBlockEntity)this.blockEntity).trackerCount;
            case 12 -> ((UnpackagerBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    @Override
    public void set(int id, int value) {
        if (id < 10) {
            ((UnpackagerBlockEntity)this.blockEntity).trackers[id].setSyncValue(value);
        }
        switch (id) {
            case 10: {
                ((UnpackagerBlockEntity)this.blockEntity).blocking = value != 0;
                break;
            }
            case 11: {
                ((UnpackagerBlockEntity)this.blockEntity).trackerCount = value;
                break;
            }
            case 12: {
                ((UnpackagerBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int getCount() {
        return 13;
    }

    public void updateRecipeList() {
        ((UnpackagerBlockEntity)this.blockEntity).recipeList.clear();
        ItemStack listStack = this.getStackInSlot(9);
        if (listStack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
            ((UnpackagerBlockEntity)this.blockEntity).recipeList.addAll((Collection)listStack.get(PackagedAutoDataComponents.RECIPE_LIST));
        }
        if (((UnpackagerBlockEntity)this.blockEntity).getLevel() != null && !((UnpackagerBlockEntity)this.blockEntity).getLevel().isClientSide) {
            ((UnpackagerBlockEntity)this.blockEntity).postPatternChange();
        }
    }

    public void clearRejectedIndexes() {
        for (UnpackagerBlockEntity.PackageTracker tracker : ((UnpackagerBlockEntity)this.blockEntity).trackers) {
            tracker.clearRejectedIndexes();
        }
    }
}

