/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.block.entity.EncoderBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.recipe.ProcessingPackageRecipeType;
import thelm.packagedauto.util.ApiImpl;

public class EncoderPatternItemHandler
extends BaseItemHandler<EncoderBlockEntity> {
    public final EncoderBlockEntity blockEntity;
    public IPackageRecipeType recipeType;
    public IPackageRecipeInfo recipeInfo;

    public EncoderPatternItemHandler(EncoderBlockEntity blockEntity) {
        super(blockEntity, 99);
        this.blockEntity = blockEntity;
        this.validateRecipeType();
    }

    @Override
    public void onContentsChanged(int slot) {
        this.updateRecipeInfo(true);
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        super.load(nbt, registries);
        this.recipeType = ApiImpl.INSTANCE.getRecipeType(ResourceLocation.parse((String)nbt.getString("racipe_type")));
        this.validateRecipeType();
        this.updateRecipeInfo(false);
    }

    @Override
    public void save(CompoundTag nbt, HolderLookup.Provider registries) {
        super.save(nbt, registries);
        this.validateRecipeType();
        nbt.putString("racipe_type", this.recipeType.getName().toString());
    }

    public boolean isItemValid(int index, ItemStack stack) {
        this.validateRecipeType();
        if (index < 81 || this.recipeType.canSetOutput() && index < 90) {
            return this.recipeType.getEnabledSlots().contains(index);
        }
        return false;
    }

    public void validateRecipeType() {
        if (this.recipeType == null) {
            this.recipeType = ProcessingPackageRecipeType.INSTANCE;
        }
    }

    public void updateRecipeInfo(boolean mark) {
        this.validateRecipeType();
        if (!this.blockEntity.hasLevel()) {
            return;
        }
        IPackageRecipeInfo info = this.recipeType.generateRecipeInfoFromStacks(this.stacks.subList(0, 81), this.recipeType.canSetOutput() ? this.stacks.subList(81, 90) : List.of(), this.blockEntity.getLevel());
        if (info.isPackageable()) {
            if (this.recipeInfo == null || !this.recipeInfo.equals(info)) {
                this.recipeInfo = info;
                if (!this.recipeType.canSetOutput()) {
                    for (int i = 81; i < 90; ++i) {
                        this.stacks.set(i, (Object)ItemStack.EMPTY);
                    }
                    List<ItemStack> outputs = info.getOutputs();
                    int size = outputs.size();
                    for (int i = 0; i < size; ++i) {
                        this.stacks.set(81 + i, (Object)outputs.get(i).copy());
                    }
                }
                for (int i = 90; i < 99; ++i) {
                    this.stacks.set(i, (Object)ItemStack.EMPTY);
                }
                List<IPackagePattern> patterns = info.getPatterns();
                for (int i = 0; i < patterns.size() && i < 9; ++i) {
                    this.stacks.set(90 + i, (Object)patterns.get(i).getOutput().copy());
                }
                if (mark) {
                    this.sync(false);
                    this.setChanged();
                }
            }
        } else if (this.recipeInfo != null) {
            int i;
            this.recipeInfo = null;
            if (!this.recipeType.canSetOutput()) {
                for (i = 81; i < 90; ++i) {
                    this.stacks.set(i, (Object)ItemStack.EMPTY);
                }
            }
            for (i = 90; i < 99; ++i) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
            if (mark) {
                this.sync(false);
                this.setChanged();
            }
        }
    }

    public void cycleRecipeType(boolean reverse) {
        this.validateRecipeType();
        do {
            this.recipeType = ApiImpl.INSTANCE.getNextRecipeType(this.recipeType, reverse);
        } while (this.recipeType != null && this.recipeType != ProcessingPackageRecipeType.INSTANCE && EncoderBlockEntity.disabledRecipeTypes.contains(this.recipeType.getName().toString()));
        this.validateRecipeType();
        IntSet enabledSlots = this.recipeType.getEnabledSlots();
        for (int i = 0; i < 90; ++i) {
            if (enabledSlots.contains(i)) continue;
            this.stacks.set(i, (Object)ItemStack.EMPTY);
        }
        this.updateRecipeInfo(true);
        for (EncoderPatternItemHandler patternItemHandler : this.blockEntity.patternItemHandlers) {
            if (patternItemHandler == this) continue;
            patternItemHandler.setRecipeTypeIfEmpty(this.recipeType);
        }
    }

    public void setRecipeTypeIfEmpty(IPackageRecipeType recipeType) {
        if (this.stacks.stream().allMatch(ItemStack::isEmpty)) {
            this.recipeType = recipeType;
            this.validateRecipeType();
            this.updateRecipeInfo(true);
        }
    }

    public void setRecipe(Int2ObjectMap<ItemStack> map) {
        int i;
        for (i = 0; i < 81; ++i) {
            this.stacks.set(i, (Object)ItemStack.EMPTY);
        }
        if (this.recipeType.canSetOutput()) {
            for (i = 81; i < 90; ++i) {
                this.stacks.set(i, (Object)ItemStack.EMPTY);
            }
        }
        if (map != null) {
            for (Int2ObjectMap.Entry entry : map.int2ObjectEntrySet()) {
                this.stacks.set(entry.getIntKey(), (Object)((ItemStack)entry.getValue()));
            }
        }
        this.updateRecipeInfo(true);
    }
}

