/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.block.entity.FluidPackageFillerBlockEntity;
import thelm.packagedauto.client.FluidRenderer;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.FluidPackageFillerMenu;
import thelm.packagedauto.packet.SetFluidAmountPacket;

public class FluidPackageFillerScreen
extends BaseScreen<FluidPackageFillerMenu> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"packagedauto:textures/gui/fluid_package_filler.png");
    public static final FluidRenderer FLUID_RENDERER = new FluidRenderer(16, 52, 1);
    protected EditBox amountField;

    public FluidPackageFillerScreen(FluidPackageFillerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    protected void init() {
        this.clearWidgets();
        super.init();
        Objects.requireNonNull(this.font);
        this.amountField = new EditBox(this.font, this.leftPos + 30, this.topPos + 57, 41, 9, (Component)Component.empty());
        this.amountField.setBordered(false);
        this.amountField.setValue(String.valueOf(((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).requiredAmount));
        this.amountField.setTextColor(0xFFFFFF);
        this.amountField.setFilter(s -> {
            if (((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).isWorking) {
                return false;
            }
            if (s.isEmpty()) {
                return true;
            }
            try {
                int amount = Integer.parseInt(s);
                return amount >= 1 && amount <= 1000000000;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.amountField.setResponder(s -> {
            try {
                int amount = Mth.clamp((int)Integer.parseInt(this.amountField.getValue()), (int)1, (int)1000000000);
                if (amount != ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).requiredAmount) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetFluidAmountPacket(amount), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        });
        this.addRenderableWidget((GuiEventListener)this.amountField);
    }

    @Override
    protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(BACKGROUND, this.leftPos + 102, this.topPos + 35, 176, 0, ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).getScaledProgress(22), 16);
        int scaledEnergy = ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).getScaledEnergy(40);
        graphics.blit(BACKGROUND, this.leftPos + 10, this.topPos + 10 + 40 - scaledEnergy, 176, 56 - scaledEnergy, 12, scaledEnergy);
        if (((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).isWorking) {
            graphics.blit(BACKGROUND, this.leftPos + 102, this.topPos + 30, 176, 61, 6, 5);
        } else {
            graphics.blit(BACKGROUND, this.leftPos + 102, this.topPos + 30, 176, 56, 6, 5);
        }
        this.amountField.renderWidget(graphics, mouseX, mouseY, partialTicks);
        FluidStack stack = ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).currentFluid.copy();
        if (!stack.isEmpty()) {
            stack.setAmount(((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).amount);
            FLUID_RENDERER.render(graphics, this.leftPos + 80, this.topPos + 17, stack, ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).requiredAmount);
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        String s = ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).getDisplayName().getString();
        graphics.drawString(this.font, s, this.imageWidth / 2 - this.font.width(s) / 2, 6, 0x404040, false);
        graphics.drawString(this.font, ((FluidPackageFillerMenu)this.menu).inventory.getDisplayName().getString(), ((FluidPackageFillerMenu)this.menu).getPlayerInvX(), ((FluidPackageFillerMenu)this.menu).getPlayerInvY() - 11, 0x404040, false);
        if (mouseX - this.leftPos >= 10 && mouseY - this.topPos >= 10 && mouseX - this.leftPos <= 21 && mouseY - this.topPos <= 49) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)(((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).getEnergyStorage().getEnergyStored() + " / " + ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).getEnergyStorage().getMaxEnergyStored() + " FE")), mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (!((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).isWorking && mouseX - this.leftPos >= 102 && mouseY - this.topPos >= 30 && mouseX - this.leftPos <= 107 && mouseY - this.topPos <= 34) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)"block.packagedauto.fluid_package_filler.redstone"), mouseX - this.leftPos, mouseY - this.topPos);
        }
        if (((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).isWorking && !((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).currentFluid.isEmpty() && mouseX - this.leftPos >= 80 && mouseY - this.topPos >= 17 && mouseX - this.leftPos <= 95 && mouseY - this.topPos <= 68) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)"").append(((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).currentFluid.getHoverName()).append(" " + ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).amount + " / " + ((FluidPackageFillerBlockEntity)((FluidPackageFillerMenu)this.menu).blockEntity).requiredAmount + " mB"), mouseX - this.leftPos, mouseY - this.topPos);
        }
        super.renderLabels(graphics, mouseX, mouseY);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (this.amountField.keyPressed(key, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)key, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) && this.amountField.isFocused()) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }
}

