/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.craft;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ItemFilter;
import de.ellpeck.prettypipes.network.ActiveCraft;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class CraftingModuleItem
extends ModuleItem {
    private final int speed;

    public CraftingModuleItem(String name, ModuleTier tier) {
        super(name, new Item.Properties().component(Contents.TYPE, (Object)new Contents(new ItemStackHandler(tier.forTier(1, 4, 9).intValue()), new ItemStackHandler(tier.forTier(1, 2, 4).intValue()), false, InsertionType.ALL, false)));
        this.speed = tier.forTier(20, 10, 5);
    }

    @Override
    public boolean isCompatible(ItemStack module, PipeBlockEntity tile, IModule other) {
        return true;
    }

    @Override
    public boolean hasContainer(ItemStack module, PipeBlockEntity tile) {
        return true;
    }

    @Override
    public AbstractPipeContainer<?> getContainer(ItemStack module, PipeBlockEntity tile, int windowId, Inventory inv, Player player, int moduleIndex) {
        return new CraftingModuleContainer(Registry.craftingModuleContainer, windowId, player, tile.getBlockPos(), moduleIndex);
    }

    @Override
    public boolean canNetworkSee(ItemStack module, PipeBlockEntity tile, Direction direction, IItemHandler handler) {
        return false;
    }

    @Override
    public boolean canAcceptItem(ItemStack module, PipeBlockEntity tile, ItemStack stack, Direction direction, IItemHandler destination) {
        return false;
    }

    @Override
    public void tick(ItemStack module, PipeBlockEntity tile) {
        if (!tile.shouldWorkNow(this.speed) || !tile.canWork()) {
            return;
        }
        int slot = tile.getModuleSlot(module);
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        boolean foundMainCraft = false;
        Iterator<ActiveCraft> crafts = tile.getActiveCrafts().iterator();
        while (crafts.hasNext()) {
            Pair<BlockPos, ItemStack> dest;
            ActiveCraft craft = crafts.next();
            if (!foundMainCraft) {
                if (!craft.ingredientsToRequest.isEmpty()) {
                    if (craft.moduleSlot == slot) {
                        network.startProfile("crafting_ingredients");
                        Either<NetworkLock, ItemStack> ingredient = craft.ingredientsToRequest.getFirst();
                        ItemStack toRequest = (ItemStack)ingredient.map(l -> l.stack, s -> s);
                        Pair<BlockPos, ItemStack> dest2 = tile.getAvailableDestination(Direction.values(), toRequest, true, true);
                        if (dest2 != null && (((Contents)module.get(Contents.TYPE)).insertionType != InsertionType.PER_ITEM || craft.travelingIngredients.isEmpty())) {
                            ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
                            ItemStack remain = ((ItemStack)ingredient.map(l -> network.requestExistingItem(l.location, tile.getBlockPos(), (BlockPos)dest2.getLeft(), (NetworkLock)l, (ItemStack)dest2.getRight(), equalityTypes), s -> network.requestExistingItem(tile.getBlockPos(), (BlockPos)dest2.getLeft(), null, (ItemStack)dest2.getRight(), equalityTypes))).copy();
                            remain.grow(toRequest.getCount() - ((ItemStack)dest2.getRight()).getCount());
                            if (remain.getCount() != toRequest.getCount()) {
                                ingredient.ifLeft(network::resolveNetworkLock);
                                craft.ingredientsToRequest.removeFirst();
                                if (!remain.isEmpty()) {
                                    craft.ingredientsToRequest.addFirst((Either<NetworkLock, ItemStack>)Either.right((Object)remain));
                                }
                                craft.travelingIngredients.add(toRequest.copyWithCount(toRequest.getCount() - remain.getCount()));
                                craft.inProgress = true;
                            }
                        }
                        network.endProfile();
                    }
                    foundMainCraft = true;
                } else if (!craft.travelingIngredients.isEmpty()) {
                    foundMainCraft = true;
                } else if (!craft.resultFound) {
                    if (craft.moduleSlot == slot) {
                        if (craft.resultStackRemain.isEmpty()) {
                            crafts.remove();
                        } else {
                            List<NetworkLocation> items = network.getOrderedNetworkItems(tile.getBlockPos());
                            ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
                            network.startProfile("check_crafting_results");
                            ItemStack remain = craft.resultStackRemain.copy();
                            for (NetworkLocation item : items) {
                                remain.shrink(item.getItemAmount(tile.getLevel(), remain, equalityTypes) - network.getLockedAmount(item.getPos(), remain, null, equalityTypes));
                                if (!remain.isEmpty()) continue;
                                break;
                            }
                            craft.resultFound = remain.isEmpty();
                            network.endProfile();
                        }
                    }
                    foundMainCraft = true;
                }
            }
            if (!craft.resultFound || craft.moduleSlot != slot) continue;
            network.startProfile("pull_crafting_results");
            PipeBlockEntity destPipe = network.getPipe(craft.resultDestPipe);
            if (destPipe != null && (dest = destPipe.getAvailableDestinationOrConnectable(craft.resultStackRemain, true, true)) != null) {
                ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
                ItemStack requestRemain = network.requestExistingItem(craft.resultDestPipe, (BlockPos)dest.getLeft(), null, (ItemStack)dest.getRight(), equalityTypes);
                craft.resultStackRemain.shrink(((ItemStack)dest.getRight()).getCount() - requestRemain.getCount());
                if (craft.resultStackRemain.isEmpty()) {
                    crafts.remove();
                    break;
                }
            }
            network.endProfile();
        }
    }

    @Override
    public List<ItemStack> getAllCraftables(ItemStack module, PipeBlockEntity tile) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStackHandler output = ((Contents)module.get(Contents.TYPE)).output;
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack stack = output.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    public int getCraftableAmount(ItemStack module, PipeBlockEntity tile, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        network.startProfile("get_craftable_amount");
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.getBlockPos());
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        Contents content = (Contents)module.get(Contents.TYPE);
        int craftable = 0;
        for (int i = 0; i < content.output.getSlots(); ++i) {
            ItemStack out = content.output.getStackInSlot(i);
            if (out.isEmpty() || !ItemEquality.compareItems(out, stack, equalityTypes)) continue;
            int availableCrafts = CraftingTerminalBlockEntity.getAvailableCrafts(tile, content.input.getSlots(), arg_0 -> ((ItemStackHandler)content.input).getStackInSlot(arg_0), k -> true, s -> items, unavailableConsumer, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
            if (availableCrafts <= 0) continue;
            craftable += out.getCount() * availableCrafts;
        }
        network.endProfile();
        return craftable;
    }

    @Override
    public Pair<ItemStack, Collection<ActiveCraft>> craft(ItemStack module, PipeBlockEntity tile, BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain) {
        int c;
        int craftableAmount = this.getCraftableAmount(module, tile, unavailableConsumer, stack, dependencyChain);
        if (craftableAmount <= 0) {
            return Pair.of((Object)stack, List.of());
        }
        PipeNetwork network = PipeNetwork.get(tile.getLevel());
        network.startProfile("craft");
        List<NetworkLocation> items = network.getOrderedNetworkItems(tile.getBlockPos());
        int slot = tile.getModuleSlot(module);
        Contents contents = (Contents)module.get(Contents.TYPE);
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        int resultAmount = this.getResultAmountPerCraft(module, stack, equalityTypes);
        int requiredCrafts = Mth.ceil((float)((float)stack.getCount() / (float)resultAmount));
        int craftableCrafts = Mth.ceil((float)((float)craftableAmount / (float)resultAmount));
        int toCraft = Math.min(craftableCrafts, requiredCrafts);
        int leftOfRequest = stack.getCount();
        ArrayList<ActiveCraft> allCrafts = new ArrayList<ActiveCraft>();
        int n = c = contents.insertionType != InsertionType.ALL ? toCraft : 1;
        while (c > 0) {
            ArrayList<Either<NetworkLock, ItemStack>> toRequest = new ArrayList<Either<NetworkLock, ItemStack>>();
            for (int i = 0; i < contents.input.getSlots(); ++i) {
                ItemStack in = contents.input.getStackInSlot(i);
                if (in.isEmpty()) continue;
                ItemStack request = in.copy();
                if (contents.insertionType == InsertionType.ALL) {
                    request.setCount(in.getCount() * toCraft);
                }
                Triple<List<NetworkLock>, ItemStack, Collection<ActiveCraft>> ret = network.requestLocksAndStartCrafting(tile.getBlockPos(), items, unavailableConsumer, request, CraftingModuleItem.addDependency(dependencyChain, module), equalityTypes);
                for (NetworkLock lock : (List)ret.getLeft()) {
                    toRequest.add((Either<NetworkLock, ItemStack>)Either.left((Object)lock));
                }
                for (ActiveCraft dep : (Collection)ret.getRight()) {
                    if (dep.resultStackRemain.isEmpty()) continue;
                    dep.inProgress = true;
                    toRequest.add((Either<NetworkLock, ItemStack>)Either.right((Object)dep.resultStackRemain));
                    dep.resultStackRemain = ItemStack.EMPTY;
                    allCrafts.add(dep);
                }
            }
            int crafted = contents.insertionType != InsertionType.ALL ? resultAmount : resultAmount * toCraft;
            ActiveCraft activeCraft = new ActiveCraft(tile.getBlockPos(), slot, toRequest, new ArrayList<ItemStack>(), destPipe, stack.copyWithCount(Math.min(crafted, leftOfRequest)));
            tile.getActiveCrafts().add(activeCraft);
            allCrafts.add(activeCraft);
            leftOfRequest -= crafted;
            --c;
        }
        network.endProfile();
        ItemStack remain = stack.copy();
        remain.shrink(resultAmount * toCraft);
        return Pair.of((Object)remain, allCrafts);
    }

    @Override
    public ItemStack store(ItemStack module, PipeBlockEntity tile, ItemStack stack, Direction direction) {
        int slot = tile.getModuleSlot(module);
        Contents contents = (Contents)module.get(Contents.TYPE);
        ItemEquality[] equalityTypes = ItemFilter.getEqualityTypes(tile);
        List<ActiveCraft> allCrafts = tile.getActiveCrafts();
        for (ActiveCraft craft : allCrafts.stream().filter(c -> c.moduleSlot == slot && !c.getTravelingIngredient(stack, equalityTypes).isEmpty()).toList()) {
            IItemHandler handler;
            ItemStack traveling = craft.getTravelingIngredient(stack, equalityTypes);
            traveling.shrink(stack.getCount());
            if (traveling.isEmpty()) {
                craft.travelingIngredients.remove(traveling);
            }
            if (contents.insertUnstacked && (handler = tile.getItemHandler(direction)) != null) {
                ItemStack remain;
                while (!stack.isEmpty() && (remain = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.copyWithCount(1), (boolean)false)).isEmpty()) {
                    stack.shrink(1);
                }
            }
            if (!craft.ingredientsToRequest.isEmpty() || !craft.travelingIngredients.isEmpty()) continue;
            if (contents.emitRedstone) {
                tile.redstoneTicks = 5;
                tile.getLevel().updateNeighborsAt(tile.getBlockPos(), tile.getBlockState().getBlock());
            }
            if (!craft.canceled) continue;
            allCrafts.remove(craft);
        }
        return stack;
    }

    private int getResultAmountPerCraft(ItemStack module, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStackHandler output = ((Contents)module.get(Contents.TYPE)).output;
        int resultAmount = 0;
        for (int i = 0; i < output.getSlots(); ++i) {
            ItemStack out = output.getStackInSlot(i);
            if (!ItemEquality.compareItems(stack, out, equalityTypes)) continue;
            resultAmount += out.getCount();
        }
        return resultAmount;
    }

    private static Stack<ItemStack> addDependency(Stack<ItemStack> deps, ItemStack module) {
        deps = (Stack)deps.clone();
        deps.push(module);
        return deps;
    }

    public record Contents(ItemStackHandler input, ItemStackHandler output, boolean emitRedstone, InsertionType insertionType, boolean insertUnstacked) {
        public static final Codec<Contents> CODEC = RecordCodecBuilder.create(i -> i.group((App)Utility.ITEM_STACK_HANDLER_CODEC.fieldOf("input").forGetter(d -> d.input), (App)Utility.ITEM_STACK_HANDLER_CODEC.fieldOf("output").forGetter(d -> d.output), (App)Codec.BOOL.optionalFieldOf("emit_redstone", (Object)false).forGetter(d -> d.emitRedstone), (App)Codec.STRING.xmap(InsertionType::valueOf, Enum::name).optionalFieldOf("insertion_type", (Object)InsertionType.ALL).forGetter(d -> d.insertionType), (App)Codec.BOOL.optionalFieldOf("insert_unstacked", (Object)false).forGetter(d -> d.insertUnstacked)).apply((Applicative)i, Contents::new));
        public static final DataComponentType<Contents> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }

    public static enum InsertionType {
        ALL,
        PER_ITEM,
        PER_CRAFT;


        public String translationKey() {
            return "info.prettypipes.insertion_type." + this.name().toLowerCase(Locale.ROOT);
        }
    }
}

