/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.craft;

import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeGui;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;

public class CraftingModuleGui
extends AbstractPipeGui<CraftingModuleContainer> {
    public CraftingModuleGui(CraftingModuleContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTicks, mouseX, mouseY);
        graphics.blit(AbstractPipeGui.TEXTURE, this.leftPos + 88 - 8, this.topPos + 32 + 36, 176, 80, 16, 16);
    }

    @Override
    protected void init() {
        super.init();
        Supplier<String> redstoneText = () -> "info.prettypipes.emit_redstone_" + (((CraftingModuleContainer)this.menu).emitRedstone ? "on" : "off");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)redstoneText.get()), button -> {
            PacketButton.sendAndExecute(((CraftingModuleContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.EMIT_REDSTONE_BUTTON, List.of());
            button.setMessage((Component)Component.translatable((String)((String)redstoneText.get())));
        }).bounds(this.leftPos + this.imageWidth - 7 - 20, this.topPos + 17 + 32 + 36 + 2, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"info.prettypipes.emit_redstone.description").withStyle(ChatFormatting.GRAY))).build());
        Supplier<String> unstackedText = () -> "info.prettypipes.insert_unstacked_" + (((CraftingModuleContainer)this.menu).insertUnstacked ? "on" : "off");
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)unstackedText.get()), button -> {
            PacketButton.sendAndExecute(((CraftingModuleContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.INSERT_UNSTACKED_BUTTON, List.of());
            button.setMessage((Component)Component.translatable((String)((String)unstackedText.get())));
        }).bounds(this.leftPos + this.imageWidth - 7 - 20 - 22, this.topPos + 17 + 32 + 36 + 2, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"info.prettypipes.insert_unstacked.description").withStyle(ChatFormatting.GRAY))).build());
        Supplier<MutableComponent> insertionTypeText = () -> Component.translatable((String)((CraftingModuleContainer)this.menu).insertionType.translationKey());
        Supplier<Tooltip> insertionTypeTooltip = () -> Tooltip.create((Component)Component.translatable((String)(((CraftingModuleContainer)this.menu).insertionType.translationKey() + ".description")).withStyle(ChatFormatting.GRAY));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)insertionTypeText.get()), button -> {
            PacketButton.sendAndExecute(((CraftingModuleContainer)this.menu).tile.getBlockPos(), PacketButton.ButtonResult.INSERTION_TYPE_BUTTON, List.of());
            button.setMessage((Component)insertionTypeText.get());
            button.setTooltip((Tooltip)insertionTypeTooltip.get());
        }).bounds(this.leftPos + 7, this.topPos + 17 + 32 + 36 + 2, 42, 20).tooltip(insertionTypeTooltip.get()).build());
    }
}

