/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.containers;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;

public abstract class AbstractPipeGui<T extends AbstractPipeContainer<?>>
extends AbstractContainerScreen<T> {
    protected static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"textures/gui/pipe.png");
    private final List<Tab> tabs = new ArrayList<Tab>();
    private final ItemStack[] lastItems;

    public AbstractPipeGui(T screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.lastItems = new ItemStack[((AbstractPipeContainer)this.menu).tile.modules.getSlots()];
        this.imageWidth = 176;
        this.imageHeight = 203;
    }

    protected void init() {
        super.init();
        this.initTabs();
    }

    public void containerTick() {
        super.containerTick();
        boolean changed = false;
        for (int i = 0; i < ((AbstractPipeContainer)this.menu).tile.modules.getSlots(); ++i) {
            ItemStack stack = ((AbstractPipeContainer)this.menu).tile.modules.getStackInSlot(i);
            if (stack == this.lastItems[i]) continue;
            this.lastItems[i] = stack;
            changed = true;
        }
        if (changed) {
            this.initTabs();
        }
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.playerInventoryTitle.getString(), 8, this.imageHeight - 96 + 2, 0x404040, false);
        graphics.drawString(this.font, this.title.getString(), 8, 38, 0x404040, false);
        for (Tab tab : this.tabs) {
            tab.drawForeground(graphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(TEXTURE, this.leftPos, this.topPos + 32, 0, 0, 176, 171);
        for (Tab tab : this.tabs) {
            tab.draw(graphics);
        }
        for (Slot slot : ((AbstractPipeContainer)this.menu).slots) {
            if (!(slot instanceof SlotItemHandler)) continue;
            graphics.blit(TEXTURE, this.leftPos + slot.x - 1, this.topPos + slot.y - 1, 176, 62, 18, 18);
        }
    }

    public boolean mouseClicked(double x, double y, int button) {
        for (Tab tab : this.tabs) {
            if (!tab.onClicked(x, y, button)) continue;
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    private void initTabs() {
        this.tabs.clear();
        this.tabs.add(new Tab(new ItemStack((ItemLike)Registry.pipeBlock), 0, -1));
        for (int i = 0; i < ((AbstractPipeContainer)this.menu).tile.modules.getSlots(); ++i) {
            IModule module;
            ItemStack stack = ((AbstractPipeContainer)this.menu).tile.modules.getStackInSlot(i);
            if (stack.isEmpty() || !(module = (IModule)stack.getItem()).hasContainer(stack, ((AbstractPipeContainer)this.menu).tile)) continue;
            this.tabs.add(new Tab(stack, this.tabs.size(), i));
        }
    }

    private class Tab {
        private final ItemStack moduleStack;
        private final int index;
        private final int x;
        private final int y;

        public Tab(ItemStack moduleStack, int tabIndex, int index) {
            this.moduleStack = moduleStack;
            this.index = index;
            this.x = AbstractPipeGui.this.leftPos + 5 + tabIndex * 28;
            this.y = AbstractPipeGui.this.topPos;
        }

        private void draw(GuiGraphics graphics) {
            int y = 2;
            int v = 0;
            int height = 30;
            int itemOffset = 9;
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).menu).moduleIndex) {
                y = 0;
                v = 30;
                height = 32;
                itemOffset = 7;
            }
            graphics.blit(TEXTURE, this.x, this.y + y, 176, v, 28, height);
            graphics.renderItem(this.moduleStack, this.x + 6, this.y + itemOffset);
        }

        private void drawForeground(GuiGraphics graphics, int mouseX, int mouseY) {
            if (mouseX < this.x || mouseY < this.y || mouseX >= this.x + 28 || mouseY >= this.y + 32) {
                return;
            }
            graphics.renderTooltip(AbstractPipeGui.this.font, this.moduleStack.getHoverName(), mouseX - AbstractPipeGui.this.leftPos, mouseY - AbstractPipeGui.this.topPos);
        }

        private boolean onClicked(double mouseX, double mouseY, int button) {
            if (this.index == ((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).menu).moduleIndex) {
                return false;
            }
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX >= (double)(this.x + 28) || mouseY >= (double)(this.y + 32)) {
                return false;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new PacketButton(((AbstractPipeContainer)((AbstractPipeGui)AbstractPipeGui.this).menu).tile.getBlockPos(), PacketButton.ButtonResult.PIPE_TAB, List.of(Integer.valueOf(this.index))), (CustomPacketPayload[])new CustomPacketPayload[0]);
            AbstractPipeGui.this.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
    }
}

