/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketRequest(BlockPos pos, ItemStack stack, int componentsHash, int amount) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"request"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketRequest> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketRequest::pos, (StreamCodec)ItemStack.STREAM_CODEC, PacketRequest::stack, (StreamCodec)ByteBufCodecs.INT, PacketRequest::componentsHash, (StreamCodec)ByteBufCodecs.INT, PacketRequest::amount, PacketRequest::new);

    public PacketRequest(BlockPos pos, ItemStack stack, int amount) {
        this(pos, stack, !stack.isComponentsPatchEmpty() ? stack.getComponents().hashCode() : 0, amount);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(PacketRequest message, IPayloadContext ctx) {
        Player player = ctx.player();
        ItemTerminalBlockEntity tile = Utility.getBlockEntity(ItemTerminalBlockEntity.class, (BlockGetter)player.level(), message.pos);
        message.stack.setCount(message.amount);
        tile.requestItem(player, message.stack, message.componentsHash);
    }
}

