/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGhostSlot(BlockPos pos, List<Entry> stacks) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketGhostSlot> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"prettypipes", (String)"ghost_slot"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketGhostSlot> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketGhostSlot::pos, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, Entry.CODEC), PacketGhostSlot::stacks, PacketGhostSlot::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void onMessage(PacketGhostSlot message, IPayloadContext ctx) {
        Player player = ctx.player();
        CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)player.level(), message.pos);
        if (tile != null) {
            tile.setGhostItems(message.stacks);
        }
    }

    public record Entry(Optional<List<ItemStack>> stacks, Optional<TagKey<Item>> tag) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC), Entry::stacks, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.fromCodec((Codec)TagKey.codec((ResourceKey)Registries.ITEM))), Entry::tag, Entry::new);

        public static Entry fromStacks(Level level, List<ItemStack> stacks) {
            TagKey<Item> tag = Entry.getTagForStacks(level, stacks);
            if (tag != null) {
                return new Entry(Optional.empty(), Optional.of(tag));
            }
            return new Entry(Optional.of(stacks), Optional.empty());
        }

        public List<ItemStack> getStacks(Level level) {
            return this.stacks.orElseGet(() -> Streams.stream(((Registry)level.registryAccess().registry(Registries.ITEM).orElseThrow()).getTagOrEmpty(this.tag.orElseThrow()).iterator()).filter(h -> h.value() != null & h.value() != Items.AIR).map(h -> new ItemStack((ItemLike)h.value())).collect(Collectors.toList()));
        }

        private static TagKey<Item> getTagForStacks(Level level, List<ItemStack> stacks) {
            return ((Registry)level.registryAccess().registry(Registries.ITEM).orElseThrow()).getTags().filter(e -> {
                HolderSet.Named tag = (HolderSet.Named)e.getSecond();
                if (tag.size() != stacks.size()) {
                    return false;
                }
                for (int i = 0; i < tag.size(); ++i) {
                    if (((ItemStack)stacks.get(i)).getItem() == tag.get(i).value()) continue;
                    return false;
                }
                return true;
            }).map(Pair::getFirst).findFirst().orElse(null);
        }
    }
}

