/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Streams;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.ActiveCraft;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.packets.PacketItemEnterPipe;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.ListenableGraph;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class PipeNetwork
extends SavedData
implements GraphListener<BlockPos, NetworkEdge> {
    private static final SavedData.Factory<PipeNetwork> FACTORY = new SavedData.Factory(PipeNetwork::new, PipeNetwork::new);
    private static PipeNetwork clientNetwork;
    public final ListenableGraph<BlockPos, NetworkEdge> graph;
    private final DijkstraShortestPath<BlockPos, NetworkEdge> dijkstra;
    private final Map<BlockPos, List<BlockPos>> nodeToConnectedNodes = new HashMap<BlockPos, List<BlockPos>>();
    private final Map<BlockPos, PipeBlockEntity> tileCache = new HashMap<BlockPos, PipeBlockEntity>();
    private final ListMultimap<BlockPos, IPipeItem> pipeItems = ArrayListMultimap.create();
    private final ListMultimap<BlockPos, NetworkLock> networkLocks = ArrayListMultimap.create();
    private final ListMultimap<BlockPos, ActiveCraft> activeCrafts = ArrayListMultimap.create();
    private Level level;

    public PipeNetwork() {
        this.graph = new DefaultListenableGraph((Graph)new SimpleWeightedGraph(NetworkEdge.class));
        this.graph.addGraphListener((GraphListener)this);
        this.dijkstra = new DijkstraShortestPath(this.graph);
    }

    public PipeNetwork(CompoundTag nbt, HolderLookup.Provider provider) {
        this();
        for (Tag node : nbt.getList("nodes", 11)) {
            this.graph.addVertex((Object)Utility.readBlockPos(node));
        }
        ListTag edges = nbt.getList("edges", 10);
        for (int i2 = 0; i2 < edges.size(); ++i2) {
            this.addEdge(new NetworkEdge(provider, edges.getCompound(i2)));
        }
        for (IPipeItem item : Utility.deserializeAll(nbt.getList("items", 10), i -> IPipeItem.load(provider, i))) {
            this.pipeItems.put((Object)item.getCurrentPipe(), (Object)item);
        }
        for (NetworkLock lock : Utility.deserializeAll(nbt.getList("locks", 10), t -> new NetworkLock(provider, (CompoundTag)t))) {
            this.createNetworkLock(lock);
        }
        for (ActiveCraft craft : Utility.deserializeAll(nbt.getList("crafts", 10), t -> new ActiveCraft(provider, (CompoundTag)t))) {
            this.activeCrafts.put((Object)craft.pipe, (Object)craft);
        }
    }

    public void edgeAdded(GraphEdgeChangeEvent<BlockPos, NetworkEdge> e) {
        this.clearDestinationCache(((NetworkEdge)((Object)e.getEdge())).pipes);
    }

    public void edgeRemoved(GraphEdgeChangeEvent<BlockPos, NetworkEdge> e) {
        this.clearDestinationCache(((NetworkEdge)((Object)e.getEdge())).pipes);
    }

    public void vertexAdded(GraphVertexChangeEvent<BlockPos> e) {
    }

    public void vertexRemoved(GraphVertexChangeEvent<BlockPos> e) {
    }

    public boolean isDirty() {
        return true;
    }

    public String toString() {
        return "graph:\n\tnodes: " + String.valueOf(this.graph.edgeSet()) + "\n\tedges: " + String.valueOf(this.graph.edgeSet()) + "\nnodeToConnectedNodes:\n" + PipeNetwork.toNewlineDelimitedString(this.nodeToConnectedNodes.entrySet()) + "\ntileCache:\n" + PipeNetwork.toNewlineDelimitedString(this.tileCache.keySet()) + "\npipeItems:\n" + PipeNetwork.toNewlineDelimitedString(this.pipeItems.entries()) + "\nnetworkLocks:\n" + PipeNetwork.toNewlineDelimitedString(this.networkLocks.entries()) + "\nactiveCrafts:\n" + PipeNetwork.toNewlineDelimitedString(this.activeCrafts.entries());
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        ListTag nodes = new ListTag();
        for (BlockPos node : this.graph.vertexSet()) {
            nodes.add((Object)NbtUtils.writeBlockPos((BlockPos)node));
        }
        nbt.put("nodes", (Tag)nodes);
        ListTag edges = new ListTag();
        for (NetworkEdge edge : this.graph.edgeSet()) {
            edges.add((Object)edge.serializeNBT(provider));
        }
        nbt.put("edges", (Tag)edges);
        nbt.put("items", (Tag)Utility.serializeAll(this.pipeItems.values(), i -> (CompoundTag)i.serializeNBT(provider)));
        nbt.put("locks", (Tag)Utility.serializeAll(this.networkLocks.values(), l -> l.serializeNBT(provider)));
        nbt.put("crafts", (Tag)Utility.serializeAll(this.activeCrafts.values(), c -> c.serializeNBT(provider)));
        return nbt;
    }

    public void addNode(BlockPos pos, BlockState state) {
        if (!this.isNode(pos)) {
            this.graph.addVertex((Object)pos);
            this.refreshNode(pos, state);
        }
    }

    public void removeNode(BlockPos pos) {
        if (this.isNode(pos)) {
            this.graph.removeVertex((Object)pos);
        }
    }

    public boolean isNode(BlockPos pos) {
        return this.graph.containsVertex((Object)pos);
    }

    public void onPipeChanged(BlockPos pos, BlockState state) {
        List<NetworkEdge> neighbors = this.createAllEdges(pos, state, true);
        if (neighbors.size() <= 1 && !this.isNode(pos)) {
            return;
        }
        for (NetworkEdge edge : neighbors) {
            BlockPos end = edge.getEndPipe();
            this.refreshNode(end, this.level.getBlockState(end));
        }
    }

    public ItemStack routeItem(BlockPos startPipePos, BlockPos startInventory, ItemStack stack, boolean preventOversending) {
        return this.routeItem(startPipePos, startInventory, stack, PipeItem::new, preventOversending);
    }

    public ItemStack routeItem(BlockPos startPipePos, BlockPos startInventory, ItemStack stack, BiFunction<ItemStack, Float, IPipeItem> itemSupplier, boolean preventOversending) {
        if (!this.isNode(startPipePos)) {
            return stack;
        }
        if (!this.level.isLoaded(startPipePos)) {
            return stack;
        }
        PipeBlockEntity startPipe = this.getPipe(startPipePos);
        if (startPipe == null) {
            return stack;
        }
        this.startProfile("find_destination");
        List<BlockPos> nodes = this.getOrderedNetworkNodes(startPipePos);
        for (int i = 0; i < nodes.size(); ++i) {
            PipeBlockEntity pipe;
            Pair<BlockPos, ItemStack> dest;
            BlockPos pipePos = nodes.get(startPipe.getNextNode(nodes, i));
            if (!this.level.isLoaded(pipePos) || (dest = (pipe = this.getPipe(pipePos)).getAvailableDestination(Direction.values(), stack, false, preventOversending)) == null || ((BlockPos)dest.getLeft()).equals((Object)startInventory)) continue;
            Function<Float, IPipeItem> sup = speed -> (IPipeItem)itemSupplier.apply((ItemStack)dest.getRight(), (Float)speed);
            if (!this.routeItemToLocation(startPipePos, startInventory, pipe.getBlockPos(), (BlockPos)dest.getLeft(), (ItemStack)dest.getRight(), sup)) continue;
            ItemStack remain = stack.copy();
            remain.shrink(((ItemStack)dest.getRight()).getCount());
            this.endProfile();
            return remain;
        }
        this.endProfile();
        return stack;
    }

    public boolean routeItemToLocation(BlockPos startPipePos, BlockPos startInventory, BlockPos destPipePos, BlockPos destInventory, ItemStack stack, Function<Float, IPipeItem> itemSupplier) {
        if (!this.isNode(startPipePos) || !this.isNode(destPipePos)) {
            return false;
        }
        if (!this.level.isLoaded(startPipePos) || !this.level.isLoaded(destPipePos)) {
            return false;
        }
        PipeBlockEntity startPipe = this.getPipe(startPipePos);
        if (startPipe == null) {
            return false;
        }
        this.startProfile("get_path");
        GraphPath path = this.dijkstra.getPath((Object)startPipePos, (Object)destPipePos);
        this.endProfile();
        if (path == null) {
            return false;
        }
        IPipeItem item = itemSupplier.apply(Float.valueOf(startPipe.getItemSpeed(stack)));
        item.setDestination(startInventory, destInventory, (GraphPath<BlockPos, NetworkEdge>)path);
        startPipe.addNewItem(item);
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(startPipePos), (CustomPacketPayload)new PacketItemEnterPipe(startPipePos, (CompoundTag)item.serializeNBT((HolderLookup.Provider)this.level.registryAccess())), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return true;
    }

    public ItemStack requestItem(BlockPos destPipe, BlockPos destInventory, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStack remain = this.requestExistingItem(destPipe, destInventory, null, stack, equalityTypes);
        if (remain.isEmpty()) {
            return remain;
        }
        return (ItemStack)this.requestCraftedItem(destPipe, null, remain, new Stack<ItemStack>(), equalityTypes).getLeft();
    }

    public Triple<List<NetworkLock>, ItemStack, Collection<ActiveCraft>> requestLocksAndStartCrafting(BlockPos destPipe, Collection<NetworkLocation> locations, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        ArrayList<NetworkLock> requests = new ArrayList<NetworkLock>();
        ItemStack remain = stack.copy();
        for (NetworkLocation location : locations) {
            int amount = location.getItemAmount(this.level, stack, equalityTypes);
            if (amount <= 0 || (amount -= this.getLockedAmount(location.getPos(), stack, null, equalityTypes)) <= 0) continue;
            if (remain.getCount() < amount) {
                amount = remain.getCount();
            }
            remain.shrink(amount);
            while (amount > 0) {
                ItemStack copy = stack.copy();
                copy.setCount(Math.min(stack.getMaxStackSize(), amount));
                NetworkLock lock = new NetworkLock(location, copy);
                this.createNetworkLock(lock);
                requests.add(lock);
                amount -= copy.getCount();
            }
            if (!remain.isEmpty()) continue;
            break;
        }
        if (!remain.isEmpty()) {
            Pair<ItemStack, Collection<ActiveCraft>> started = this.requestCraftedItem(destPipe, unavailableConsumer, remain, dependencyChain, equalityTypes);
            return Triple.of(requests, (Object)((ItemStack)started.getLeft()), (Object)((Collection)started.getRight()));
        }
        return Triple.of(requests, (Object)remain, List.of());
    }

    public Pair<ItemStack, Collection<ActiveCraft>> requestCraftedItem(BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        ArrayList crafts = new ArrayList();
        for (Pair<BlockPos, ItemStack> craftable : this.getAllCraftables(destPipe)) {
            PipeBlockEntity pipe;
            if (!ItemEquality.compareItems(stack, (ItemStack)craftable.getRight(), equalityTypes) || (pipe = this.getPipe((BlockPos)craftable.getLeft())) == null) continue;
            Pair<ItemStack, Collection<ActiveCraft>> started = pipe.craft(destPipe, unavailableConsumer, stack, dependencyChain);
            stack = (ItemStack)started.getLeft();
            crafts.addAll((Collection)started.getRight());
            if (!stack.isEmpty()) continue;
            break;
        }
        return Pair.of((Object)stack, crafts);
    }

    public ItemStack requestExistingItem(BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStack remain = stack.copy();
        for (NetworkLocation location : this.getOrderedNetworkItems(destPipe)) {
            remain = this.requestExistingItem(location, destPipe, destInventory, ignoredLock, remain, equalityTypes);
            if (!remain.isEmpty()) continue;
            return remain;
        }
        return remain;
    }

    public ItemStack requestExistingItem(NetworkLocation location, BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, ItemStack stack, ItemEquality ... equalityTypes) {
        return this.requestExistingItem(location, destPipe, destInventory, ignoredLock, PipeItem::new, stack, equalityTypes);
    }

    public ItemStack requestExistingItem(NetworkLocation location, BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, BiFunction<ItemStack, Float, IPipeItem> itemSupplier, ItemStack stack, ItemEquality ... equalityTypes) {
        if (location.getPos().equals((Object)destInventory)) {
            return stack;
        }
        int available = location.getItemAmount(this.level, stack, equalityTypes);
        if (available <= 0) {
            return stack;
        }
        if ((available -= this.getLockedAmount(location.getPos(), stack, ignoredLock, equalityTypes)) <= 0) {
            return stack;
        }
        int toExtract = Math.min(stack.getCount(), available);
        int extractedSoFar = 0;
        for (int slot : location.getStackSlots(this.level, stack, equalityTypes)) {
            IItemHandler handler = location.getItemHandler(this.level);
            ItemStack extracted = handler.extractItem(slot, toExtract - extractedSoFar, true);
            if (!this.routeItemToLocation(location.pipePos, location.getPos(), destPipe, destInventory, extracted, speed -> (IPipeItem)itemSupplier.apply(extracted, (Float)speed))) continue;
            handler.extractItem(slot, extracted.getCount(), false);
            if ((extractedSoFar += extracted.getCount()) < toExtract) continue;
            break;
        }
        return stack.copyWithCount(stack.getCount() - extractedSoFar);
    }

    public PipeBlockEntity getPipe(BlockPos pos) {
        PipeBlockEntity tile = this.tileCache.get(pos);
        if ((tile == null || tile.isRemoved()) && (tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)this.level, pos)) != null) {
            this.tileCache.put(pos, tile);
        }
        return tile;
    }

    public void uncachePipe(BlockPos pos) {
        this.tileCache.remove(pos);
    }

    public List<Pair<BlockPos, ItemStack>> getCurrentlyCrafting(BlockPos node, boolean includeCanceled, ItemEquality ... equalityTypes) {
        this.startProfile("get_currently_crafting");
        ArrayList<Pair<BlockPos, ItemStack>> items = new ArrayList<Pair<BlockPos, ItemStack>>();
        Iterator craftingPipes = this.getAllCraftables(node).stream().map(c -> this.getPipe((BlockPos)c.getLeft())).distinct().iterator();
        while (craftingPipes.hasNext()) {
            PipeBlockEntity pipe = (PipeBlockEntity)craftingPipes.next();
            for (ActiveCraft craft : pipe.getActiveCrafts()) {
                if (!includeCanceled && craft.canceled || craft.resultStackRemain.isEmpty()) continue;
                Optional<Pair> existing = items.stream().filter(s -> ((BlockPos)s.getLeft()).equals((Object)craft.resultDestPipe) && ItemEquality.compareItems((ItemStack)s.getRight(), craft.resultStackRemain, equalityTypes)).findFirst();
                if (existing.isPresent()) {
                    ((ItemStack)existing.get().getRight()).grow(craft.resultStackRemain.getCount());
                    continue;
                }
                items.add((Pair<BlockPos, ItemStack>)Pair.of((Object)craft.resultDestPipe, (Object)craft.resultStackRemain.copy()));
            }
        }
        this.endProfile();
        return items;
    }

    public int getCurrentlyCraftingAmount(BlockPos destNode, ItemStack stack, boolean includeCanceled, ItemEquality ... equalityTypes) {
        return this.getCurrentlyCrafting(destNode, includeCanceled, new ItemEquality[0]).stream().filter(p -> ((BlockPos)p.getLeft()).equals((Object)destNode) && ItemEquality.compareItems((ItemStack)p.getRight(), stack, equalityTypes)).mapToInt(p -> ((ItemStack)p.getRight()).getCount()).sum();
    }

    public List<Pair<BlockPos, ItemStack>> getAllCraftables(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        this.startProfile("get_all_craftables");
        ArrayList<Pair<BlockPos, ItemStack>> craftables = new ArrayList<Pair<BlockPos, ItemStack>>();
        for (BlockPos dest : this.getOrderedNetworkNodes(node)) {
            if (!this.level.isLoaded(dest)) continue;
            PipeBlockEntity pipe = this.getPipe(dest);
            for (ItemStack stack : pipe.getAllCraftables()) {
                craftables.add((Pair<BlockPos, ItemStack>)Pair.of((Object)pipe.getBlockPos(), (Object)stack));
            }
        }
        this.endProfile();
        return craftables;
    }

    public int getCraftableAmount(BlockPos node, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        int total = 0;
        for (Pair<BlockPos, ItemStack> pair : this.getAllCraftables(node)) {
            PipeBlockEntity pipe;
            if (!ItemEquality.compareItems((ItemStack)pair.getRight(), stack, equalityTypes) || !this.level.isLoaded((BlockPos)pair.getLeft()) || (pipe = this.getPipe((BlockPos)pair.getLeft())) == null) continue;
            total += pipe.getCraftableAmount(unavailableConsumer, stack, dependencyChain);
        }
        return total;
    }

    public List<NetworkLocation> getOrderedNetworkItems(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        this.startProfile("get_network_items");
        LinkedHashMap<IItemHandler, NetworkLocation> ret = new LinkedHashMap<IItemHandler, NetworkLocation>();
        for (BlockPos dest : this.getOrderedNetworkNodes(node)) {
            if (!this.level.isLoaded(dest)) continue;
            PipeBlockEntity pipe = this.getPipe(dest);
            for (Direction dir : Direction.values()) {
                NetworkLocation location;
                IItemHandler handler = pipe.getItemHandler(dir);
                if (handler == null || !pipe.canNetworkSee(dir, handler) || ret.containsKey(handler) || (location = new NetworkLocation(dest, dir)).isEmpty(this.level)) continue;
                ret.put(handler, location);
            }
        }
        this.endProfile();
        return new ArrayList<NetworkLocation>(ret.values());
    }

    public void createNetworkLock(NetworkLock lock) {
        this.networkLocks.put((Object)lock.location.getPos(), (Object)lock);
    }

    public void resolveNetworkLock(NetworkLock lock) {
        this.networkLocks.remove((Object)lock.location.getPos(), (Object)lock);
    }

    public List<NetworkLock> getNetworkLocks(BlockPos pos) {
        return this.networkLocks.get((Object)pos);
    }

    public int getLockedAmount(BlockPos pos, ItemStack stack, NetworkLock ignoredLock, ItemEquality ... equalityTypes) {
        return this.getNetworkLocks(pos).stream().filter(l -> !l.equals(ignoredLock) && ItemEquality.compareItems(l.stack, stack, equalityTypes)).mapToInt(l -> l.stack.getCount()).sum();
    }

    private void refreshNode(BlockPos pos, BlockState state) {
        this.startProfile("refresh_node");
        this.graph.removeAllEdges(new ArrayList(this.graph.edgesOf((Object)pos)));
        for (NetworkEdge edge : this.createAllEdges(pos, state, false)) {
            this.addEdge(edge);
        }
        this.endProfile();
    }

    private void addEdge(NetworkEdge edge) {
        this.graph.addEdge((Object)edge.getStartPipe(), (Object)edge.getEndPipe(), (Object)edge);
        this.graph.setEdgeWeight((Object)edge, (double)(edge.pipes.size() - 1));
    }

    public BlockPos getNodeFromPipe(BlockPos pos) {
        if (this.isNode(pos)) {
            return pos;
        }
        BlockState state = this.level.getBlockState(pos);
        if (!(state.getBlock() instanceof PipeBlock)) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            NetworkEdge edge = this.createEdge(pos, state, dir, false);
            if (edge == null) continue;
            return edge.getEndPipe();
        }
        return null;
    }

    public void clearCaches() {
        this.nodeToConnectedNodes.clear();
        this.tileCache.clear();
    }

    public void unlock() {
        this.networkLocks.clear();
    }

    public void cancelCrafts() {
        this.activeCrafts.entries().removeIf(c -> ((ActiveCraft)c.getValue()).markCanceledOrResolve(this, true));
    }

    private List<NetworkEdge> createAllEdges(BlockPos pos, BlockState state, boolean ignoreCurrBlocked) {
        this.startProfile("create_all_edges");
        ArrayList<NetworkEdge> edges = new ArrayList<NetworkEdge>();
        for (Direction dir : Direction.values()) {
            NetworkEdge edge = this.createEdge(pos, state, dir, ignoreCurrBlocked);
            if (edge == null) continue;
            edges.add(edge);
        }
        this.endProfile();
        return edges;
    }

    private NetworkEdge createEdge(BlockPos pos, BlockState state, Direction dir, boolean ignoreCurrBlocked) {
        boolean found;
        if (!ignoreCurrBlocked && !((ConnectionType)((Object)state.getValue((Property)PipeBlock.DIRECTIONS.get(dir)))).isConnected()) {
            return null;
        }
        BlockPos currPos = pos.relative(dir);
        BlockState currState = this.level.getBlockState(currPos);
        if (!(currState.getBlock() instanceof PipeBlock)) {
            return null;
        }
        this.startProfile("create_edge");
        NetworkEdge edge = new NetworkEdge();
        edge.pipes.add(pos);
        edge.pipes.add(currPos);
        block0: do {
            if (this.isNode(currPos)) {
                this.endProfile();
                return edge;
            }
            found = false;
            for (Direction nextDir : Direction.values()) {
                BlockPos offset;
                BlockState offState;
                if (!((ConnectionType)((Object)currState.getValue((Property)PipeBlock.DIRECTIONS.get(nextDir)))).isConnected() || !((offState = this.level.getBlockState(offset = currPos.relative(nextDir))).getBlock() instanceof PipeBlock) || edge.pipes.contains(offset)) continue;
                edge.pipes.add(offset);
                currPos = offset;
                currState = offState;
                found = true;
                continue block0;
            }
        } while (found);
        this.endProfile();
        return null;
    }

    public List<BlockPos> getOrderedNetworkNodes(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        List<Object> ret = this.nodeToConnectedNodes.get(node);
        if (ret == null) {
            this.startProfile("compile_connected_nodes");
            ShortestPathAlgorithm.SingleSourcePaths paths = this.dijkstra.getPaths((Object)node);
            ret = Streams.stream((Iterator)new BreadthFirstIterator(this.graph, (Object)node)).filter(p -> this.getPipe((BlockPos)p) != null).sorted(Comparator.comparingInt(p -> this.getPipe((BlockPos)p).getPriority()).reversed().thenComparing(arg_0 -> ((ShortestPathAlgorithm.SingleSourcePaths)paths).getWeight(arg_0))).collect(Collectors.toList());
            this.nodeToConnectedNodes.put(node, ret);
            this.endProfile();
        }
        return ret;
    }

    public void clearDestinationCache(List<BlockPos> nodes) {
        this.startProfile("clear_node_cache");
        for (BlockPos node : nodes) {
            this.nodeToConnectedNodes.remove(node);
        }
        this.nodeToConnectedNodes.values().removeIf(cached -> nodes.stream().anyMatch(cached::contains));
        this.endProfile();
    }

    public List<IPipeItem> getItemsInPipe(BlockPos pos) {
        return this.pipeItems.get((Object)pos);
    }

    public List<ActiveCraft> getActiveCrafts(BlockPos pos) {
        return this.activeCrafts.get((Object)pos);
    }

    public Stream<IPipeItem> getPipeItemsOnTheWay(BlockPos goalInv) {
        this.startProfile("get_pipe_items_on_the_way");
        Stream<IPipeItem> ret = this.pipeItems.values().stream().filter(i -> i.getDestInventory().equals((Object)goalInv));
        this.endProfile();
        return ret;
    }

    public int getItemsOnTheWay(BlockPos goalInv, ItemStack type, ItemEquality ... equalityTypes) {
        return this.getPipeItemsOnTheWay(goalInv).filter(i -> type == null || ItemEquality.compareItems(i.getContent(), type, equalityTypes)).mapToInt(i -> i.getItemsOnTheWay(goalInv)).sum();
    }

    public void startProfile(String name) {
        if (this.level != null) {
            this.level.getProfiler().push(() -> "prettypipes:pipe_network_" + name);
        }
    }

    public void endProfile() {
        if (this.level != null) {
            this.level.getProfiler().pop();
        }
    }

    public static PipeNetwork get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            PipeNetwork ret = (PipeNetwork)server.getDataStorage().computeIfAbsent(FACTORY, "pipe_network");
            if (ret.level == null) {
                ret.level = level;
            }
            return ret;
        }
        if (clientNetwork == null || PipeNetwork.clientNetwork.level != level) {
            clientNetwork = new PipeNetwork();
            PipeNetwork.clientNetwork.level = level;
        }
        return clientNetwork;
    }

    private static String toNewlineDelimitedString(Collection<?> collection) {
        return collection.stream().map(c -> "\t" + c.toString()).collect(Collectors.joining("\n"));
    }
}

