/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import de.ellpeck.prettypipes.Utility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jgrapht.graph.DefaultWeightedEdge;

public class NetworkEdge
extends DefaultWeightedEdge
implements INBTSerializable<CompoundTag> {
    public final List<BlockPos> pipes = new ArrayList<BlockPos>();

    public NetworkEdge() {
    }

    public NetworkEdge(HolderLookup.Provider provider, CompoundTag nbt) {
        this.deserializeNBT(provider, nbt);
    }

    public BlockPos getStartPipe() {
        return this.pipes.getFirst();
    }

    public BlockPos getEndPipe() {
        return this.pipes.getLast();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag list = new ListTag();
        for (BlockPos pos : this.pipes) {
            list.add((Object)NbtUtils.writeBlockPos((BlockPos)pos));
        }
        nbt.put("pipes", (Tag)list);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.pipes.clear();
        for (Tag tag : nbt.getList("pipes", 11)) {
            this.pipes.add(Utility.readBlockPos(tag));
        }
    }
}

