/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ItemFilter {
    public final ItemStackHandler content;
    public boolean isWhitelist;
    public boolean canPopulateFromInventories;
    public boolean canModifyWhitelist = true;
    private final ItemStack stack;
    private final PipeBlockEntity pipe;
    private boolean modified;

    public ItemFilter(int size, ItemStack stack, PipeBlockEntity pipe) {
        this.content = new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                ItemFilter.this.modified = true;
            }
        };
        this.stack = stack;
        this.pipe = pipe;
        this.load();
    }

    public List<Slot> getSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.content.getSlots(); ++i) {
            slots.add((Slot)new FilterSlot((IItemHandler)this.content, i, x + i % 9 * 18, y + i / 9 * 18, true));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AbstractWidget> getButtons(Screen gui, int x, int y, boolean rightAligned) {
        ArrayList<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
        if (this.canModifyWhitelist) {
            Supplier<String> whitelistText = () -> "info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist");
            Supplier<Tooltip> tooltip = () -> Tooltip.create((Component)Component.translatable((String)((String)whitelistText.get() + ".description")).withStyle(ChatFormatting.GRAY));
            buttons.add((AbstractWidget)Button.builder((Component)Component.translatable((String)whitelistText.get()), button -> {
                PacketButton.sendAndExecute(this.pipe.getBlockPos(), PacketButton.ButtonResult.FILTER_CHANGE, List.of(Integer.valueOf(0)));
                button.setMessage((Component)Component.translatable((String)((String)whitelistText.get())));
                button.setTooltip((Tooltip)tooltip.get());
            }).bounds(x - 20, y, 20, 20).tooltip(tooltip.get()).build());
        }
        if (this.canPopulateFromInventories) {
            buttons.add((AbstractWidget)Button.builder((Component)Component.translatable((String)"info.prettypipes.populate"), button -> PacketButton.sendAndExecute(this.pipe.getBlockPos(), PacketButton.ButtonResult.FILTER_CHANGE, List.of(Integer.valueOf(1)))).bounds(x - 42, y, 20, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"info.prettypipes.populate.description").withStyle(ChatFormatting.GRAY))).build());
        }
        return buttons;
    }

    public void onButtonPacket(IFilteredContainer menu, int id) {
        if (id == 0 && this.canModifyWhitelist) {
            this.isWhitelist = !this.isWhitelist;
            this.modified = true;
            this.save();
        } else if (id == 1 && this.canPopulateFromInventories) {
            boolean changed = false;
            List<ItemFilter> filters = this.pipe.getFilters(null);
            for (Direction direction : Direction.values()) {
                IItemHandler handler = this.pipe.getItemHandler(direction);
                if (handler == null) continue;
                block1: for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.isEmpty() || this.isFiltered(stack, null)) continue;
                    ItemStack copy = stack.copy();
                    copy.setCount(1);
                    for (ItemFilter filter : filters) {
                        if (!ItemHandlerHelper.insertItem((IItemHandler)filter.content, (ItemStack)copy, (boolean)false).isEmpty()) continue;
                        changed = true;
                        filter.save();
                        continue block1;
                    }
                }
            }
            if (changed) {
                menu.onFilterPopulated();
            }
        }
    }

    public boolean isAllowed(ItemStack stack, Direction direction) {
        return this.isFiltered(stack, direction) == this.isWhitelist;
    }

    private boolean isFiltered(ItemStack stack, Direction direction) {
        ItemEquality[] types = ItemFilter.getEqualityTypes(this.pipe);
        for (ItemFilter handler : this.pipe.getFilters(direction)) {
            for (int i = 0; i < handler.content.getSlots(); ++i) {
                ItemStack filter = handler.content.getStackInSlot(i);
                if (filter.isEmpty() || !ItemEquality.compareItems(stack, filter, types)) continue;
                return true;
            }
        }
        return false;
    }

    public void save() {
        if (this.modified) {
            this.stack.set(Data.TYPE, (Object)new Data(this.content, this.isWhitelist));
            this.pipe.setChanged();
            this.modified = false;
        }
    }

    public void load() {
        Data content = (Data)this.stack.get(Data.TYPE);
        if (content != null) {
            Utility.copyInto(content.items, this.content);
            this.isWhitelist = content.whitelist;
        }
    }

    public static ItemEquality[] getEqualityTypes(PipeBlockEntity pipe) {
        return (ItemEquality[])pipe.streamModules().filter(m -> m.getRight() instanceof FilterModifierModuleItem).map(m -> ((FilterModifierModuleItem)m.getRight()).getEqualityType((ItemStack)m.getLeft())).toArray(ItemEquality[]::new);
    }

    public static interface IFilteredContainer {
        public ItemFilter getFilter();

        default public void onFilterPopulated() {
        }
    }

    public record Data(ItemStackHandler items, boolean whitelist) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(i -> i.group((App)Utility.ITEM_STACK_HANDLER_CODEC.fieldOf("items").forGetter(f -> f.items), (App)Codec.BOOL.fieldOf("whitelist").forGetter(f -> f.whitelist)).apply((Applicative)i, Data::new));
        public static final DataComponentType<Data> TYPE = DataComponentType.builder().persistent(CODEC).cacheEncoding().build();
    }
}

