/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.packets.PacketCraftingModuleTransfer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class CraftingModuleTransferHandler
implements IUniversalRecipeTransferHandler<CraftingModuleContainer> {
    public Class<CraftingModuleContainer> getContainerClass() {
        return CraftingModuleContainer.class;
    }

    public Optional<MenuType<CraftingModuleContainer>> getMenuType() {
        return Optional.of(Registry.craftingModuleContainer);
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CraftingModuleContainer container, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (IRecipeSlotView entry : recipeSlots.getSlotViews()) {
            ItemStack lastAdded;
            List allIngredients = entry.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList();
            if (allIngredients.isEmpty()) continue;
            ItemStack remain = ((ItemStack)allIngredients.getFirst()).copy();
            ArrayList<ItemStack> toAdd = entry.getRole() == RecipeIngredientRole.INPUT ? inputs : outputs;
            ItemStack itemStack = lastAdded = toAdd.isEmpty() ? ItemStack.EMPTY : toAdd.getLast();
            if (ItemEquality.compareItems(lastAdded, remain, new ItemEquality[0])) {
                int fits = Math.min(lastAdded.getMaxStackSize() - lastAdded.getCount(), remain.getCount());
                lastAdded.grow(fits);
                remain.shrink(fits);
            }
            if (remain.isEmpty()) continue;
            toAdd.add(remain);
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketCraftingModuleTransfer(inputs, outputs), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return null;
    }
}

