/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;

public final class Utility {
    public static final Codec<ItemStackHandler> ITEM_STACK_HANDLER_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("size").forGetter(h -> h.getSlots()), (App)Codec.list((Codec)ItemStack.OPTIONAL_CODEC).fieldOf("items").forGetter(h -> IntStream.range(0, h.getSlots()).mapToObj(arg_0 -> ((ItemStackHandler)h).getStackInSlot(arg_0)).toList())).apply((Applicative)builder, (size, items) -> {
        ItemStackHandler ret = new ItemStackHandler(size.intValue());
        for (int i = 0; i < items.size(); ++i) {
            ret.setStackInSlot(i, (ItemStack)items.get(i));
        }
        return ret;
    }));

    public static <T extends BlockEntity> T getBlockEntity(Class<T> type, BlockGetter world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return (T)(type.isInstance(tile) ? tile : null);
    }

    public static void dropInventory(BlockEntity tile, IItemHandler inventory) {
        BlockPos pos = tile.getBlockPos();
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            Containers.dropItemStack((Level)tile.getLevel(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)stack);
        }
    }

    public static Direction getDirectionFromOffset(BlockPos pos, BlockPos other) {
        BlockPos diff = pos.subtract((Vec3i)other);
        return Direction.fromDelta((int)diff.getX(), (int)diff.getY(), (int)diff.getZ());
    }

    public static void addTooltip(String name, List<Component> tooltip) {
        if (Screen.hasShiftDown()) {
            String[] content;
            for (String s : content = I18n.get((String)("info.prettypipes." + name), (Object[])new Object[0]).split("\n")) {
                tooltip.add((Component)Component.literal((String)s).setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"info.prettypipes.shift").setStyle(Style.EMPTY.applyFormat(ChatFormatting.DARK_GRAY)));
        }
    }

    public static ItemStack transferStackInSlot(AbstractContainerMenu container, IMergeItemStack merge, Player player, int slotIndex, Function<ItemStack, Pair<Integer, Integer>> predicate) {
        int inventoryStart = (int)container.slots.stream().filter(slot -> slot.container != player.getInventory()).count();
        int inventoryEnd = inventoryStart + 26;
        int hotbarStart = inventoryEnd + 1;
        int hotbarEnd = hotbarStart + 8;
        Slot slot2 = (Slot)container.slots.get(slotIndex);
        if (slot2 != null && slot2.hasItem()) {
            Pair<Integer, Integer> slots;
            ItemStack newStack = slot2.getItem();
            ItemStack currentStack = newStack.copy();
            if (slotIndex >= inventoryStart ? ((slots = predicate.apply(newStack)) != null ? !merge.mergeItemStack(newStack, (Integer)slots.getLeft(), (Integer)slots.getRight(), false) : (slotIndex >= inventoryStart && slotIndex <= inventoryEnd ? !merge.mergeItemStack(newStack, hotbarStart, hotbarEnd + 1, false) : slotIndex >= inventoryEnd + 1 && slotIndex < hotbarEnd + 1 && !merge.mergeItemStack(newStack, inventoryStart, inventoryEnd + 1, false))) : !merge.mergeItemStack(newStack, inventoryStart, hotbarEnd + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (newStack.isEmpty()) {
                slot2.set(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
            if (newStack.getCount() == currentStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot2.onTake(player, newStack);
            return currentStack;
        }
        return ItemStack.EMPTY;
    }

    public static <T> ListTag serializeAll(Collection<T> items, Function<T, CompoundTag> serializer) {
        ListTag list = new ListTag();
        for (T item : items) {
            list.add((Object)((Tag)serializer.apply(item)));
        }
        return list;
    }

    public static <T> List<T> deserializeAll(ListTag list, Function<CompoundTag, T> deserializer) {
        ArrayList<T> items = new ArrayList<T>();
        for (int i = 0; i < list.size(); ++i) {
            T item = deserializer.apply(list.getCompound(i));
            if (item == null) continue;
            items.add(item);
        }
        return items;
    }

    public static void sendBlockEntityToClients(BlockEntity tile) {
        ServerLevel world = (ServerLevel)tile.getLevel();
        List entities = world.getChunkSource().chunkMap.getPlayers(new ChunkPos(tile.getBlockPos()), false);
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)tile, BlockEntity::saveWithoutMetadata);
        for (ServerPlayer e : entities) {
            e.connection.send((Packet)packet);
        }
    }

    public static BlockPos readBlockPos(Tag tag) {
        IntArrayTag i;
        int[] arr;
        if (tag instanceof IntArrayTag && (arr = (i = (IntArrayTag)tag).getAsIntArray()).length == 3) {
            return new BlockPos(arr[0], arr[1], arr[2]);
        }
        return null;
    }

    public static void copyInto(ItemStackHandler handler, ItemStackHandler dest) {
        dest.setSize(handler.getSlots());
        for (int i = 0; i < handler.getSlots(); ++i) {
            dest.setStackInSlot(i, handler.getStackInSlot(i).copy());
        }
    }

    public static ItemStackHandler copy(ItemStackHandler handler) {
        ItemStackHandler ret = new ItemStackHandler();
        Utility.copyInto(handler, ret);
        return ret;
    }

    public static interface IMergeItemStack {
        public boolean mergeItemStack(ItemStack var1, int var2, int var3, boolean var4);
    }
}

