/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.effects.potion;

import com.github.L_Ender.cataclysm.client.particle.Options.RingParticleOptions;
import io.redspace.ironsspellbooks.damage.DamageSources;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class CursedFrenzyEffect
extends MobEffect {
    public CursedFrenzyEffect() {
        super(MobEffectCategory.BENEFICIAL, 4583645);
    }

    public boolean applyEffectTick(LivingEntity pLivingEntity, int amplifier) {
        List entitiesNearby = pLivingEntity.level().getEntities((Entity)pLivingEntity, pLivingEntity.getBoundingBox().inflate(0.25, 0.5, 0.25));
        if (!entitiesNearby.isEmpty()) {
            for (Entity targets : entitiesNearby) {
                if (!(targets instanceof LivingEntity)) continue;
                DamageSources.applyDamage((Entity)targets, (float)amplifier, (DamageSource)SpellRegistries.CURSED_RUSH.get().getDamageSource((Entity)pLivingEntity));
                targets.invulnerableTime = 20;
            }
        } else if (pLivingEntity.horizontalCollision || pLivingEntity.minorHorizontalCollision) {
            return false;
        }
        pLivingEntity.fallDistance = 0.0f;
        if (pLivingEntity.level().isClientSide && pLivingEntity.tickCount % 3 == 0) {
            double x = pLivingEntity.getX();
            double y = pLivingEntity.getY() + (double)(pLivingEntity.getBbHeight() / 2.0f);
            double z = pLivingEntity.getZ();
            float yaw = (float)Math.toRadians(-pLivingEntity.getYRot());
            float yaw2 = (float)Math.toRadians(-pLivingEntity.getYRot() + 180.0f);
            float pitch = (float)Math.toRadians(-pLivingEntity.getXRot());
            pLivingEntity.level().addParticle((ParticleOptions)new RingParticleOptions(yaw, pitch, 40, 86, 236, 204, 1.0f, 50.0f, false, 2), x, y, z, 0.0, 0.0, 0.0);
            pLivingEntity.level().addParticle((ParticleOptions)new RingParticleOptions(yaw2, pitch, 40, 86, 236, 204, 1.0f, 50.0f, false, 2), x, y, z, 0.0, 0.0, 0.0);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

