/*
 * Decompiled with CFR 0.152.
 */
package reliquary.common.gui;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import reliquary.common.gui.SlotMobCharm;
import reliquary.init.ModItems;
import reliquary.item.MobCharmRegistry;

public class MobCharmBeltMenu
extends AbstractContainerMenu {
    private final ItemStack belt;

    public MobCharmBeltMenu(int windowId, Inventory playerInventory, ItemStack belt) {
        super(ModItems.MOB_CHAR_BELT_MENU_TYPE.get(), windowId);
        int i;
        this.belt = belt;
        for (i = 0; i < MobCharmBeltMenu.getFirstPlayerInventoryIndex(); ++i) {
            this.addSlot(new SlotMobCharm(belt, i));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 113 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)playerInventory, k, 8 + k * 18, 171));
        }
    }

    private static int getFirstPlayerInventoryIndex() {
        return MobCharmRegistry.getRegisteredNames().size() + 1;
    }

    public void clicked(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        ItemStack slotStack;
        Slot slot = null;
        if (slotId >= 0 && slotId < this.slots.size()) {
            slot = (Slot)this.slots.get(slotId);
        }
        ItemStack itemStack = slotStack = slot == null ? ItemStack.EMPTY : slot.getItem();
        if (slot != null && !slotStack.isEmpty() && slotStack.getItem() == ModItems.MOB_CHARM_BELT.get() && slotStack == player.getMainHandItem()) {
            return;
        }
        if (slotId >= 0 && slotId < MobCharmBeltMenu.getFirstPlayerInventoryIndex() && clickTypeIn == ClickType.QUICK_MOVE && (dragType == 0 || dragType == 1)) {
            if (slot != null && slot.mayPickup(player)) {
                this.quickMoveStack(player, slotId);
            }
            return;
        }
        super.clicked(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack copiedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack originalStack = slot.getItem();
            copiedStack = originalStack.copy();
            int playerInvIndex = MobCharmBeltMenu.getFirstPlayerInventoryIndex();
            if (index < playerInvIndex) {
                if (!this.moveItemStackTo(originalStack, playerInvIndex, playerInvIndex + 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(originalStack, copiedStack);
            } else if (index < playerInvIndex + 36 && (originalStack.getItem() == ModItems.MOB_CHARM.get() ? !this.moveItemStackTo(originalStack, 0, playerInvIndex, false) : (index < playerInvIndex + 27 ? !this.moveItemStackTo(originalStack, playerInvIndex + 27, playerInvIndex + 36, false) : !this.moveItemStackTo(originalStack, playerInvIndex, playerInvIndex + 27, false)))) {
                return ItemStack.EMPTY;
            }
            if (originalStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (originalStack.getCount() == copiedStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, originalStack);
        }
        return copiedStack;
    }

    public boolean stillValid(Player playerIn) {
        return true;
    }

    public ItemStack getBelt() {
        return this.belt;
    }

    public static MobCharmBeltMenu fromBuffer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        InteractionHand hand = packetBuffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        return new MobCharmBeltMenu(windowId, playerInventory, playerInventory.player.getItemInHand(hand));
    }
}

